/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHostKeyRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateHostKeyRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(UpdateHostKeyRequest.getter(UpdateHostKeyRequest::serverId)).setter(UpdateHostKeyRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKeyId").getter(UpdateHostKeyRequest.getter(UpdateHostKeyRequest::hostKeyId)).setter(UpdateHostKeyRequest.setter(Builder::hostKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateHostKeyRequest.getter(UpdateHostKeyRequest::description)).setter(UpdateHostKeyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, HOST_KEY_ID_FIELD, DESCRIPTION_FIELD));
    private final String serverId;
    private final String hostKeyId;
    private final String description;

    private UpdateHostKeyRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.hostKeyId = builder.hostKeyId;
        this.description = builder.description;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String hostKeyId() {
        return this.hostKeyId;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostKeyRequest)) {
            return false;
        }
        UpdateHostKeyRequest other = (UpdateHostKeyRequest)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.hostKeyId(), other.hostKeyId()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHostKeyRequest").add("ServerId", (Object)this.serverId()).add("HostKeyId", (Object)this.hostKeyId()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "HostKeyId": {
                return Optional.ofNullable(clazz.cast(this.hostKeyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostKeyRequest, T> g) {
        return obj -> g.apply((UpdateHostKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String serverId;
        private String hostKeyId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostKeyRequest model) {
            super(model);
            this.serverId(model.serverId);
            this.hostKeyId(model.hostKeyId);
            this.description(model.description);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getHostKeyId() {
            return this.hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHostKeyRequest build() {
            return new UpdateHostKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHostKeyRequest> {
        public Builder serverId(String var1);

        public Builder hostKeyId(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

