/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedAccess;
import software.amazon.awssdk.services.transfer.model.ListedAccessesCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessesResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListAccessesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessesResponse.getter(ListAccessesResponse::nextToken)).setter(ListAccessesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(ListAccessesResponse.getter(ListAccessesResponse::serverId)).setter(ListAccessesResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<List<ListedAccess>> ACCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accesses").getter(ListAccessesResponse.getter(ListAccessesResponse::accesses)).setter(ListAccessesResponse.setter(Builder::accesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVER_ID_FIELD, ACCESSES_FIELD));
    private final String nextToken;
    private final String serverId;
    private final List<ListedAccess> accesses;

    private ListAccessesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverId = builder.serverId;
        this.accesses = builder.accesses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final boolean hasAccesses() {
        return this.accesses != null && !(this.accesses instanceof SdkAutoConstructList);
    }

    public final List<ListedAccess> accesses() {
        return this.accesses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccesses() ? this.accesses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessesResponse)) {
            return false;
        }
        ListAccessesResponse other = (ListAccessesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.serverId(), other.serverId()) && this.hasAccesses() == other.hasAccesses() && Objects.equals(this.accesses(), other.accesses());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessesResponse").add("NextToken", (Object)this.nextToken()).add("ServerId", (Object)this.serverId()).add("Accesses", this.hasAccesses() ? this.accesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "Accesses": {
                return Optional.ofNullable(clazz.cast(this.accesses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessesResponse, T> g) {
        return obj -> g.apply((ListAccessesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String serverId;
        private List<ListedAccess> accesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serverId(model.serverId);
            this.accesses(model.accesses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final List<ListedAccess.Builder> getAccesses() {
            List<ListedAccess.Builder> result = ListedAccessesCopier.copyToBuilder(this.accesses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccesses(Collection<ListedAccess.BuilderImpl> accesses) {
            this.accesses = ListedAccessesCopier.copyFromBuilder(accesses);
        }

        @Override
        public final Builder accesses(Collection<ListedAccess> accesses) {
            this.accesses = ListedAccessesCopier.copy(accesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accesses(ListedAccess ... accesses) {
            this.accesses(Arrays.asList(accesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accesses(Consumer<ListedAccess.Builder> ... accesses) {
            this.accesses(Stream.of(accesses).map(c -> (ListedAccess)((ListedAccess.Builder)ListedAccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessesResponse build() {
            return new ListAccessesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessesResponse> {
        public Builder nextToken(String var1);

        public Builder serverId(String var1);

        public Builder accesses(Collection<ListedAccess> var1);

        public Builder accesses(ListedAccess ... var1);

        public Builder accesses(Consumer<ListedAccess.Builder> ... var1);
    }
}

