/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestConnectionResponse extends TransferResponse implements
        ToCopyableBuilder<TestConnectionResponse.Builder, TestConnectionResponse> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(TestConnectionResponse::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TestConnectionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(TestConnectionResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private final String connectorId;

    private final String status;

    private final String statusMessage;

    private TestConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * Returns the identifier of the connector object that you are testing.
     * </p>
     * 
     * @return Returns the identifier of the connector object that you are testing.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * Returns <code>OK</code> for successful test, or <code>ERROR</code> if the test fails.
     * </p>
     * 
     * @return Returns <code>OK</code> for successful test, or <code>ERROR</code> if the test fails.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Returns <code>Connection succeeded</code> if the test is successful. Or, returns a descriptive error message if
     * the test fails. The following list provides the details for some error messages and troubleshooting steps for
     * each.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Unable to access secrets manager</b>: Verify that your secret name aligns with the one in Transfer Role
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Unknown Host/Connection failed</b>: Verify the server URL in the connector configuration , and verify that the
     * login credentials work successfully outside of the connector.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Private key not found</b>: Verify that the secret exists and is formatted correctly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Invalid trusted host keys</b>: Verify that the trusted host key in the connector configuration matches the
     * <code>ssh-keyscan</code> output.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Returns <code>Connection succeeded</code> if the test is successful. Or, returns a descriptive error
     *         message if the test fails. The following list provides the details for some error messages and
     *         troubleshooting steps for each.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Unable to access secrets manager</b>: Verify that your secret name aligns with the one in Transfer
     *         Role permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Unknown Host/Connection failed</b>: Verify the server URL in the connector configuration , and verify
     *         that the login credentials work successfully outside of the connector.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Private key not found</b>: Verify that the secret exists and is formatted correctly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Invalid trusted host keys</b>: Verify that the trusted host key in the connector configuration matches
     *         the <code>ssh-keyscan</code> output.
     *         </p>
     *         </li>
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionResponse)) {
            return false;
        }
        TestConnectionResponse other = (TestConnectionResponse) obj;
        return Objects.equals(connectorId(), other.connectorId()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestConnectionResponse").add("ConnectorId", connectorId()).add("Status", status())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestConnectionResponse, T> g) {
        return obj -> g.apply((TestConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestConnectionResponse> {
        /**
         * <p>
         * Returns the identifier of the connector object that you are testing.
         * </p>
         * 
         * @param connectorId
         *        Returns the identifier of the connector object that you are testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * Returns <code>OK</code> for successful test, or <code>ERROR</code> if the test fails.
         * </p>
         * 
         * @param status
         *        Returns <code>OK</code> for successful test, or <code>ERROR</code> if the test fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Returns <code>Connection succeeded</code> if the test is successful. Or, returns a descriptive error message
         * if the test fails. The following list provides the details for some error messages and troubleshooting steps
         * for each.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Unable to access secrets manager</b>: Verify that your secret name aligns with the one in Transfer Role
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Unknown Host/Connection failed</b>: Verify the server URL in the connector configuration , and verify that
         * the login credentials work successfully outside of the connector.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Private key not found</b>: Verify that the secret exists and is formatted correctly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Invalid trusted host keys</b>: Verify that the trusted host key in the connector configuration matches the
         * <code>ssh-keyscan</code> output.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusMessage
         *        Returns <code>Connection succeeded</code> if the test is successful. Or, returns a descriptive error
         *        message if the test fails. The following list provides the details for some error messages and
         *        troubleshooting steps for each.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Unable to access secrets manager</b>: Verify that your secret name aligns with the one in Transfer
         *        Role permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Unknown Host/Connection failed</b>: Verify the server URL in the connector configuration , and
         *        verify that the login credentials work successfully outside of the connector.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Private key not found</b>: Verify that the secret exists and is formatted correctly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Invalid trusted host keys</b>: Verify that the trusted host key in the connector configuration
         *        matches the <code>ssh-keyscan</code> output.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String connectorId;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionResponse model) {
            super(model);
            connectorId(model.connectorId);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public TestConnectionResponse build() {
            return new TestConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
