/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkflowResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeWorkflowResponse.Builder, DescribeWorkflowResponse> {
    private static final SdkField<DescribedWorkflow> WORKFLOW_FIELD = SdkField
            .<DescribedWorkflow> builder(MarshallingType.SDK_POJO).memberName("Workflow")
            .getter(getter(DescribeWorkflowResponse::workflow)).setter(setter(Builder::workflow))
            .constructor(DescribedWorkflow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_FIELD));

    private final DescribedWorkflow workflow;

    private DescribeWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflow = builder.workflow;
    }

    /**
     * <p>
     * The structure that contains the details of the workflow.
     * </p>
     * 
     * @return The structure that contains the details of the workflow.
     */
    public final DescribedWorkflow workflow() {
        return workflow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowResponse)) {
            return false;
        }
        DescribeWorkflowResponse other = (DescribeWorkflowResponse) obj;
        return Objects.equals(workflow(), other.workflow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkflowResponse").add("Workflow", workflow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workflow":
            return Optional.ofNullable(clazz.cast(workflow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowResponse, T> g) {
        return obj -> g.apply((DescribeWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkflowResponse> {
        /**
         * <p>
         * The structure that contains the details of the workflow.
         * </p>
         * 
         * @param workflow
         *        The structure that contains the details of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflow(DescribedWorkflow workflow);

        /**
         * <p>
         * The structure that contains the details of the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedWorkflow.Builder} avoiding the
         * need to create one manually via {@link DescribedWorkflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedWorkflow.Builder#build()} is called immediately and its
         * result is passed to {@link #workflow(DescribedWorkflow)}.
         * 
         * @param workflow
         *        a consumer that will call methods on {@link DescribedWorkflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflow(DescribedWorkflow)
         */
        default Builder workflow(Consumer<DescribedWorkflow.Builder> workflow) {
            return workflow(DescribedWorkflow.builder().applyMutation(workflow).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedWorkflow workflow;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowResponse model) {
            super(model);
            workflow(model.workflow);
        }

        public final DescribedWorkflow.Builder getWorkflow() {
            return workflow != null ? workflow.toBuilder() : null;
        }

        public final void setWorkflow(DescribedWorkflow.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(DescribedWorkflow workflow) {
            this.workflow = workflow;
            return this;
        }

        @Override
        public DescribeWorkflowResponse build() {
            return new DescribeWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
