/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.timestreamquery.DefaultTimestreamQueryClientBuilder;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClientBuilder;
import software.amazon.awssdk.services.timestreamquery.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ConflictException;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.InternalServerException;
import software.amazon.awssdk.services.timestreamquery.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamquery.model.QueryExecutionException;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryException;
import software.amazon.awssdk.services.timestreamquery.model.ValidationException;
import software.amazon.awssdk.services.timestreamquery.paginators.QueryIterable;

@SdkPublicApi
@ThreadSafe
public interface TimestreamQueryClient
extends SdkClient {
    public static final String SERVICE_NAME = "timestream";
    public static final String SERVICE_METADATA_ID = "query.timestream";

    public static TimestreamQueryClient create() {
        return (TimestreamQueryClient)TimestreamQueryClient.builder().build();
    }

    public static TimestreamQueryClientBuilder builder() {
        return new DefaultTimestreamQueryClientBuilder();
    }

    default public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public CancelQueryResponse cancelQuery(Consumer<CancelQueryRequest.Builder> cancelQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.cancelQuery((CancelQueryRequest)((Object)((CancelQueryRequest.Builder)CancelQueryRequest.builder().applyMutation(cancelQueryRequest)).build()));
    }

    default public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.describeEndpoints((DescribeEndpointsRequest)((Object)((DescribeEndpointsRequest.Builder)DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest)).build()));
    }

    default public QueryResponse query(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public QueryResponse query(Consumer<QueryRequest.Builder> queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.query((QueryRequest)((Object)((QueryRequest.Builder)QueryRequest.builder().applyMutation(queryRequest)).build()));
    }

    default public QueryIterable queryPaginator(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        throw new UnsupportedOperationException();
    }

    default public QueryIterable queryPaginator(Consumer<QueryRequest.Builder> queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return this.queryPaginator((QueryRequest)((Object)((QueryRequest.Builder)QueryRequest.builder().applyMutation(queryRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }
}

