/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAdapterRequest extends TextractRequest implements
        ToCopyableBuilder<UpdateAdapterRequest.Builder, UpdateAdapterRequest> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterId").getter(getter(UpdateAdapterRequest::adapterId)).setter(setter(Builder::adapterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAdapterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ADAPTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterName").getter(getter(UpdateAdapterRequest::adapterName)).setter(setter(Builder::adapterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterName").build()).build();

    private static final SdkField<String> AUTO_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoUpdate").getter(getter(UpdateAdapterRequest::autoUpdateAsString))
            .setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD,
            DESCRIPTION_FIELD, ADAPTER_NAME_FIELD, AUTO_UPDATE_FIELD));

    private final String adapterId;

    private final String description;

    private final String adapterName;

    private final String autoUpdate;

    private UpdateAdapterRequest(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.description = builder.description;
        this.adapterName = builder.adapterName;
        this.autoUpdate = builder.autoUpdate;
    }

    /**
     * <p>
     * A string containing a unique ID for the adapter that will be updated.
     * </p>
     * 
     * @return A string containing a unique ID for the adapter that will be updated.
     */
    public final String adapterId() {
        return adapterId;
    }

    /**
     * <p>
     * The new description to be applied to the adapter.
     * </p>
     * 
     * @return The new description to be applied to the adapter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new name to be applied to the adapter.
     * </p>
     * 
     * @return The new name to be applied to the adapter.
     */
    public final String adapterName() {
        return adapterName;
    }

    /**
     * <p>
     * The new auto-update status to be applied to the adapter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoUpdate} will
     * return {@link AutoUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoUpdateAsString}.
     * </p>
     * 
     * @return The new auto-update status to be applied to the adapter.
     * @see AutoUpdate
     */
    public final AutoUpdate autoUpdate() {
        return AutoUpdate.fromValue(autoUpdate);
    }

    /**
     * <p>
     * The new auto-update status to be applied to the adapter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoUpdate} will
     * return {@link AutoUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoUpdateAsString}.
     * </p>
     * 
     * @return The new auto-update status to be applied to the adapter.
     * @see AutoUpdate
     */
    public final String autoUpdateAsString() {
        return autoUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(adapterName());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAdapterRequest)) {
            return false;
        }
        UpdateAdapterRequest other = (UpdateAdapterRequest) obj;
        return Objects.equals(adapterId(), other.adapterId()) && Objects.equals(description(), other.description())
                && Objects.equals(adapterName(), other.adapterName())
                && Objects.equals(autoUpdateAsString(), other.autoUpdateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAdapterRequest").add("AdapterId", adapterId()).add("Description", description())
                .add("AdapterName", adapterName()).add("AutoUpdate", autoUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterId":
            return Optional.ofNullable(clazz.cast(adapterId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AdapterName":
            return Optional.ofNullable(clazz.cast(adapterName()));
        case "AutoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAdapterRequest, T> g) {
        return obj -> g.apply((UpdateAdapterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAdapterRequest> {
        /**
         * <p>
         * A string containing a unique ID for the adapter that will be updated.
         * </p>
         * 
         * @param adapterId
         *        A string containing a unique ID for the adapter that will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterId(String adapterId);

        /**
         * <p>
         * The new description to be applied to the adapter.
         * </p>
         * 
         * @param description
         *        The new description to be applied to the adapter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new name to be applied to the adapter.
         * </p>
         * 
         * @param adapterName
         *        The new name to be applied to the adapter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterName(String adapterName);

        /**
         * <p>
         * The new auto-update status to be applied to the adapter.
         * </p>
         * 
         * @param autoUpdate
         *        The new auto-update status to be applied to the adapter.
         * @see AutoUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoUpdate
         */
        Builder autoUpdate(String autoUpdate);

        /**
         * <p>
         * The new auto-update status to be applied to the adapter.
         * </p>
         * 
         * @param autoUpdate
         *        The new auto-update status to be applied to the adapter.
         * @see AutoUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoUpdate
         */
        Builder autoUpdate(AutoUpdate autoUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private String adapterId;

        private String description;

        private String adapterName;

        private String autoUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAdapterRequest model) {
            super(model);
            adapterId(model.adapterId);
            description(model.description);
            adapterName(model.adapterName);
            autoUpdate(model.autoUpdate);
        }

        public final String getAdapterId() {
            return adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAdapterName() {
            return adapterName;
        }

        public final void setAdapterName(String adapterName) {
            this.adapterName = adapterName;
        }

        @Override
        public final Builder adapterName(String adapterName) {
            this.adapterName = adapterName;
            return this;
        }

        public final String getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public final Builder autoUpdate(AutoUpdate autoUpdate) {
            this.autoUpdate(autoUpdate == null ? null : autoUpdate.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAdapterRequest build() {
            return new UpdateAdapterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
