/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DocumentGroupListCopier {
    static List<DocumentGroup> copy(Collection<? extends DocumentGroup> documentGroupListParam) {
        List<DocumentGroup> list;
        if (documentGroupListParam == null || documentGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentGroup> modifiableList = new ArrayList<>();
            documentGroupListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DocumentGroup> copyFromBuilder(Collection<? extends DocumentGroup.Builder> documentGroupListParam) {
        List<DocumentGroup> list;
        if (documentGroupListParam == null || documentGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentGroup> modifiableList = new ArrayList<>();
            documentGroupListParam.forEach(entry -> {
                DocumentGroup member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DocumentGroup.Builder> copyToBuilder(Collection<? extends DocumentGroup> documentGroupListParam) {
        List<DocumentGroup.Builder> list;
        if (documentGroupListParam == null || documentGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentGroup.Builder> modifiableList = new ArrayList<>();
            documentGroupListParam.forEach(entry -> {
                DocumentGroup.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
