/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DetectedSignature;
import software.amazon.awssdk.services.textract.model.DetectedSignatureListCopier;
import software.amazon.awssdk.services.textract.model.SplitDocument;
import software.amazon.awssdk.services.textract.model.SplitDocumentListCopier;
import software.amazon.awssdk.services.textract.model.UndetectedSignature;
import software.amazon.awssdk.services.textract.model.UndetectedSignatureListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentGroup> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DocumentGroup.getter(DocumentGroup::type)).setter(DocumentGroup.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<SplitDocument>> SPLIT_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SplitDocuments").getter(DocumentGroup.getter(DocumentGroup::splitDocuments)).setter(DocumentGroup.setter(Builder::splitDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SplitDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DetectedSignature>> DETECTED_SIGNATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DetectedSignatures").getter(DocumentGroup.getter(DocumentGroup::detectedSignatures)).setter(DocumentGroup.setter(Builder::detectedSignatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedSignatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectedSignature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UndetectedSignature>> UNDETECTED_SIGNATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UndetectedSignatures").getter(DocumentGroup.getter(DocumentGroup::undetectedSignatures)).setter(DocumentGroup.setter(Builder::undetectedSignatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UndetectedSignatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UndetectedSignature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SPLIT_DOCUMENTS_FIELD, DETECTED_SIGNATURES_FIELD, UNDETECTED_SIGNATURES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<SplitDocument> splitDocuments;
    private final List<DetectedSignature> detectedSignatures;
    private final List<UndetectedSignature> undetectedSignatures;

    private DocumentGroup(BuilderImpl builder) {
        this.type = builder.type;
        this.splitDocuments = builder.splitDocuments;
        this.detectedSignatures = builder.detectedSignatures;
        this.undetectedSignatures = builder.undetectedSignatures;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasSplitDocuments() {
        return this.splitDocuments != null && !(this.splitDocuments instanceof SdkAutoConstructList);
    }

    public final List<SplitDocument> splitDocuments() {
        return this.splitDocuments;
    }

    public final boolean hasDetectedSignatures() {
        return this.detectedSignatures != null && !(this.detectedSignatures instanceof SdkAutoConstructList);
    }

    public final List<DetectedSignature> detectedSignatures() {
        return this.detectedSignatures;
    }

    public final boolean hasUndetectedSignatures() {
        return this.undetectedSignatures != null && !(this.undetectedSignatures instanceof SdkAutoConstructList);
    }

    public final List<UndetectedSignature> undetectedSignatures() {
        return this.undetectedSignatures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSplitDocuments() ? this.splitDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectedSignatures() ? this.detectedSignatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUndetectedSignatures() ? this.undetectedSignatures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentGroup)) {
            return false;
        }
        DocumentGroup other = (DocumentGroup)obj;
        return Objects.equals(this.type(), other.type()) && this.hasSplitDocuments() == other.hasSplitDocuments() && Objects.equals(this.splitDocuments(), other.splitDocuments()) && this.hasDetectedSignatures() == other.hasDetectedSignatures() && Objects.equals(this.detectedSignatures(), other.detectedSignatures()) && this.hasUndetectedSignatures() == other.hasUndetectedSignatures() && Objects.equals(this.undetectedSignatures(), other.undetectedSignatures());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentGroup").add("Type", (Object)this.type()).add("SplitDocuments", this.hasSplitDocuments() ? this.splitDocuments() : null).add("DetectedSignatures", this.hasDetectedSignatures() ? this.detectedSignatures() : null).add("UndetectedSignatures", this.hasUndetectedSignatures() ? this.undetectedSignatures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "SplitDocuments": {
                return Optional.ofNullable(clazz.cast(this.splitDocuments()));
            }
            case "DetectedSignatures": {
                return Optional.ofNullable(clazz.cast(this.detectedSignatures()));
            }
            case "UndetectedSignatures": {
                return Optional.ofNullable(clazz.cast(this.undetectedSignatures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentGroup, T> g) {
        return obj -> g.apply((DocumentGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<SplitDocument> splitDocuments = DefaultSdkAutoConstructList.getInstance();
        private List<DetectedSignature> detectedSignatures = DefaultSdkAutoConstructList.getInstance();
        private List<UndetectedSignature> undetectedSignatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentGroup model) {
            this.type(model.type);
            this.splitDocuments(model.splitDocuments);
            this.detectedSignatures(model.detectedSignatures);
            this.undetectedSignatures(model.undetectedSignatures);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<SplitDocument.Builder> getSplitDocuments() {
            List<SplitDocument.Builder> result = SplitDocumentListCopier.copyToBuilder(this.splitDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSplitDocuments(Collection<SplitDocument.BuilderImpl> splitDocuments) {
            this.splitDocuments = SplitDocumentListCopier.copyFromBuilder(splitDocuments);
        }

        @Override
        public final Builder splitDocuments(Collection<SplitDocument> splitDocuments) {
            this.splitDocuments = SplitDocumentListCopier.copy(splitDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitDocuments(SplitDocument ... splitDocuments) {
            this.splitDocuments(Arrays.asList(splitDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitDocuments(Consumer<SplitDocument.Builder> ... splitDocuments) {
            this.splitDocuments(Stream.of(splitDocuments).map(c -> (SplitDocument)((SplitDocument.Builder)SplitDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DetectedSignature.Builder> getDetectedSignatures() {
            List<DetectedSignature.Builder> result = DetectedSignatureListCopier.copyToBuilder(this.detectedSignatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectedSignatures(Collection<DetectedSignature.BuilderImpl> detectedSignatures) {
            this.detectedSignatures = DetectedSignatureListCopier.copyFromBuilder(detectedSignatures);
        }

        @Override
        public final Builder detectedSignatures(Collection<DetectedSignature> detectedSignatures) {
            this.detectedSignatures = DetectedSignatureListCopier.copy(detectedSignatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectedSignatures(DetectedSignature ... detectedSignatures) {
            this.detectedSignatures(Arrays.asList(detectedSignatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectedSignatures(Consumer<DetectedSignature.Builder> ... detectedSignatures) {
            this.detectedSignatures(Stream.of(detectedSignatures).map(c -> (DetectedSignature)((DetectedSignature.Builder)DetectedSignature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UndetectedSignature.Builder> getUndetectedSignatures() {
            List<UndetectedSignature.Builder> result = UndetectedSignatureListCopier.copyToBuilder(this.undetectedSignatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUndetectedSignatures(Collection<UndetectedSignature.BuilderImpl> undetectedSignatures) {
            this.undetectedSignatures = UndetectedSignatureListCopier.copyFromBuilder(undetectedSignatures);
        }

        @Override
        public final Builder undetectedSignatures(Collection<UndetectedSignature> undetectedSignatures) {
            this.undetectedSignatures = UndetectedSignatureListCopier.copy(undetectedSignatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undetectedSignatures(UndetectedSignature ... undetectedSignatures) {
            this.undetectedSignatures(Arrays.asList(undetectedSignatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undetectedSignatures(Consumer<UndetectedSignature.Builder> ... undetectedSignatures) {
            this.undetectedSignatures(Stream.of(undetectedSignatures).map(c -> (UndetectedSignature)((UndetectedSignature.Builder)UndetectedSignature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentGroup build() {
            return new DocumentGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentGroup> {
        public Builder type(String var1);

        public Builder splitDocuments(Collection<SplitDocument> var1);

        public Builder splitDocuments(SplitDocument ... var1);

        public Builder splitDocuments(Consumer<SplitDocument.Builder> ... var1);

        public Builder detectedSignatures(Collection<DetectedSignature> var1);

        public Builder detectedSignatures(DetectedSignature ... var1);

        public Builder detectedSignatures(Consumer<DetectedSignature.Builder> ... var1);

        public Builder undetectedSignatures(Collection<UndetectedSignature> var1);

        public Builder undetectedSignatures(UndetectedSignature ... var1);

        public Builder undetectedSignatures(Consumer<UndetectedSignature.Builder> ... var1);
    }
}

