/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzeExpenseResponse extends TextractResponse implements
        ToCopyableBuilder<AnalyzeExpenseResponse.Builder, AnalyzeExpenseResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(AnalyzeExpenseResponse::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<List<ExpenseDocument>> EXPENSE_DOCUMENTS_FIELD = SdkField
            .<List<ExpenseDocument>> builder(MarshallingType.LIST)
            .memberName("ExpenseDocuments")
            .getter(getter(AnalyzeExpenseResponse::expenseDocuments))
            .setter(setter(Builder::expenseDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpenseDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpenseDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD,
            EXPENSE_DOCUMENTS_FIELD));

    private final DocumentMetadata documentMetadata;

    private final List<ExpenseDocument> expenseDocuments;

    private AnalyzeExpenseResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.expenseDocuments = builder.expenseDocuments;
    }

    /**
     * Returns the value of the DocumentMetadata property for this object.
     * 
     * @return The value of the DocumentMetadata property for this object.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpenseDocuments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExpenseDocuments() {
        return expenseDocuments != null && !(expenseDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The expenses detected by Amazon Textract.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpenseDocuments} method.
     * </p>
     * 
     * @return The expenses detected by Amazon Textract.
     */
    public final List<ExpenseDocument> expenseDocuments() {
        return expenseDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpenseDocuments() ? expenseDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeExpenseResponse)) {
            return false;
        }
        AnalyzeExpenseResponse other = (AnalyzeExpenseResponse) obj;
        return Objects.equals(documentMetadata(), other.documentMetadata())
                && hasExpenseDocuments() == other.hasExpenseDocuments()
                && Objects.equals(expenseDocuments(), other.expenseDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzeExpenseResponse").add("DocumentMetadata", documentMetadata())
                .add("ExpenseDocuments", hasExpenseDocuments() ? expenseDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "ExpenseDocuments":
            return Optional.ofNullable(clazz.cast(expenseDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeExpenseResponse, T> g) {
        return obj -> g.apply((AnalyzeExpenseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractResponse.Builder, SdkPojo, CopyableBuilder<Builder, AnalyzeExpenseResponse> {
        /**
         * Sets the value of the DocumentMetadata property for this object.
         *
         * @param documentMetadata
         *        The new value for the DocumentMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * Sets the value of the DocumentMetadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * The expenses detected by Amazon Textract.
         * </p>
         * 
         * @param expenseDocuments
         *        The expenses detected by Amazon Textract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expenseDocuments(Collection<ExpenseDocument> expenseDocuments);

        /**
         * <p>
         * The expenses detected by Amazon Textract.
         * </p>
         * 
         * @param expenseDocuments
         *        The expenses detected by Amazon Textract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expenseDocuments(ExpenseDocument... expenseDocuments);

        /**
         * <p>
         * The expenses detected by Amazon Textract.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.ExpenseDocument.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.textract.model.ExpenseDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.ExpenseDocument.Builder#build()} is called immediately
         * and its result is passed to {@link #expenseDocuments(List<ExpenseDocument>)}.
         * 
         * @param expenseDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.ExpenseDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expenseDocuments(java.util.Collection<ExpenseDocument>)
         */
        Builder expenseDocuments(Consumer<ExpenseDocument.Builder>... expenseDocuments);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private DocumentMetadata documentMetadata;

        private List<ExpenseDocument> expenseDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeExpenseResponse model) {
            super(model);
            documentMetadata(model.documentMetadata);
            expenseDocuments(model.expenseDocuments);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<ExpenseDocument.Builder> getExpenseDocuments() {
            List<ExpenseDocument.Builder> result = ExpenseDocumentListCopier.copyToBuilder(this.expenseDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpenseDocuments(Collection<ExpenseDocument.BuilderImpl> expenseDocuments) {
            this.expenseDocuments = ExpenseDocumentListCopier.copyFromBuilder(expenseDocuments);
        }

        @Override
        public final Builder expenseDocuments(Collection<ExpenseDocument> expenseDocuments) {
            this.expenseDocuments = ExpenseDocumentListCopier.copy(expenseDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expenseDocuments(ExpenseDocument... expenseDocuments) {
            expenseDocuments(Arrays.asList(expenseDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expenseDocuments(Consumer<ExpenseDocument.Builder>... expenseDocuments) {
            expenseDocuments(Stream.of(expenseDocuments).map(c -> ExpenseDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalyzeExpenseResponse build() {
            return new AnalyzeExpenseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
