/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input data for a TaskCompleted response to a decision task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RespondDecisionTaskCompletedRequest extends SwfRequest implements
        ToCopyableBuilder<RespondDecisionTaskCompletedRequest.Builder, RespondDecisionTaskCompletedRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskToken").getter(getter(RespondDecisionTaskCompletedRequest::taskToken))
            .setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<List<Decision>> DECISIONS_FIELD = SdkField
            .<List<Decision>> builder(MarshallingType.LIST)
            .memberName("decisions")
            .getter(getter(RespondDecisionTaskCompletedRequest::decisions))
            .setter(setter(Builder::decisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Decision> builder(MarshallingType.SDK_POJO)
                                            .constructor(Decision::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionContext").getter(getter(RespondDecisionTaskCompletedRequest::executionContext))
            .setter(setter(Builder::executionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionContext").build()).build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("taskList").getter(getter(RespondDecisionTaskCompletedRequest::taskList))
            .setter(setter(Builder::taskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> TASK_LIST_SCHEDULE_TO_START_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("taskListScheduleToStartTimeout")
            .getter(getter(RespondDecisionTaskCompletedRequest::taskListScheduleToStartTimeout))
            .setter(setter(Builder::taskListScheduleToStartTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskListScheduleToStartTimeout")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD,
            DECISIONS_FIELD, EXECUTION_CONTEXT_FIELD, TASK_LIST_FIELD, TASK_LIST_SCHEDULE_TO_START_TIMEOUT_FIELD));

    private final String taskToken;

    private final List<Decision> decisions;

    private final String executionContext;

    private final TaskList taskList;

    private final String taskListScheduleToStartTimeout;

    private RespondDecisionTaskCompletedRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.decisions = builder.decisions;
        this.executionContext = builder.executionContext;
        this.taskList = builder.taskList;
        this.taskListScheduleToStartTimeout = builder.taskListScheduleToStartTimeout;
    }

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     * 
     * @return The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
     *         <p>
     *         <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task
     *         is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide
     *         its progress and respond with results.
     *         </p>
     */
    public final String taskToken() {
        return taskToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Decisions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDecisions() {
        return decisions != null && !(decisions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDecisions} method.
     * </p>
     * 
     * @return The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *         docs for the <a>Decision</a> structure for details.
     */
    public final List<Decision> decisions() {
        return decisions;
    }

    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     * 
     * @return User defined context to add to workflow execution.
     */
    public final String executionContext() {
        return executionContext;
    }

    /**
     * <p>
     * The task list to use for the future decision tasks of this workflow execution. This list overrides the original
     * task list you specified while starting the workflow execution.
     * </p>
     * 
     * @return The task list to use for the future decision tasks of this workflow execution. This list overrides the
     *         original task list you specified while starting the workflow execution.
     */
    public final TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
     * override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task
     * scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon
     * SWF will revert the override and schedule a new decision task to the original task list.
     * </p>
     * <p>
     * If a decision task scheduled on the override task list is started within the timeout, but not completed within
     * the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the
     * original task list.
     * </p>
     * 
     * @return Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task
     *         list override is permanent. This parameter makes it possible to temporarily override the task list. If a
     *         decision task scheduled on the override task list is not started within the timeout, the decision task
     *         will time out. Amazon SWF will revert the override and schedule a new decision task to the original task
     *         list.</p>
     *         <p>
     *         If a decision task scheduled on the override task list is started within the timeout, but not completed
     *         within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision
     *         task to the original task list.
     */
    public final String taskListScheduleToStartTimeout() {
        return taskListScheduleToStartTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDecisions() ? decisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionContext());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(taskListScheduleToStartTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest) obj;
        return Objects.equals(taskToken(), other.taskToken()) && hasDecisions() == other.hasDecisions()
                && Objects.equals(decisions(), other.decisions()) && Objects.equals(executionContext(), other.executionContext())
                && Objects.equals(taskList(), other.taskList())
                && Objects.equals(taskListScheduleToStartTimeout(), other.taskListScheduleToStartTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RespondDecisionTaskCompletedRequest").add("TaskToken", taskToken())
                .add("Decisions", hasDecisions() ? decisions() : null).add("ExecutionContext", executionContext())
                .add("TaskList", taskList()).add("TaskListScheduleToStartTimeout", taskListScheduleToStartTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "decisions":
            return Optional.ofNullable(clazz.cast(decisions()));
        case "executionContext":
            return Optional.ofNullable(clazz.cast(executionContext()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "taskListScheduleToStartTimeout":
            return Optional.ofNullable(clazz.cast(taskListScheduleToStartTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RespondDecisionTaskCompletedRequest, T> g) {
        return obj -> g.apply((RespondDecisionTaskCompletedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
        /**
         * <p>
         * The <code>taskToken</code> from the <a>DecisionTask</a>.
         * </p>
         * <important>
         * <p>
         * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
         * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
         * progress and respond with results.
         * </p>
         * </important>
         * 
         * @param taskToken
         *        The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
         *        <p>
         *        <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the
         *        task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to
         *        provide its progress and respond with results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the <a>Decision</a> structure for details.
         * </p>
         * 
         * @param decisions
         *        The list of decisions (possibly empty) made by the decider while processing this decision task. See
         *        the docs for the <a>Decision</a> structure for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisions(Collection<Decision> decisions);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the <a>Decision</a> structure for details.
         * </p>
         * 
         * @param decisions
         *        The list of decisions (possibly empty) made by the decider while processing this decision task. See
         *        the docs for the <a>Decision</a> structure for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisions(Decision... decisions);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the <a>Decision</a> structure for details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.swf.model.Decision.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.swf.model.Decision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.swf.model.Decision.Builder#build()} is called immediately and its
         * result is passed to {@link #decisions(List<Decision>)}.
         * 
         * @param decisions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.swf.model.Decision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decisions(java.util.Collection<Decision>)
         */
        Builder decisions(Consumer<Decision.Builder>... decisions);

        /**
         * <p>
         * User defined context to add to workflow execution.
         * </p>
         * 
         * @param executionContext
         *        User defined context to add to workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionContext(String executionContext);

        /**
         * <p>
         * The task list to use for the future decision tasks of this workflow execution. This list overrides the
         * original task list you specified while starting the workflow execution.
         * </p>
         * 
         * @param taskList
         *        The task list to use for the future decision tasks of this workflow execution. This list overrides the
         *        original task list you specified while starting the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The task list to use for the future decision tasks of this workflow execution. This list overrides the
         * original task list you specified while starting the workflow execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskList.Builder} avoiding the need to
         * create one manually via {@link TaskList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list
         * override is permanent. This parameter makes it possible to temporarily override the task list. If a decision
         * task scheduled on the override task list is not started within the timeout, the decision task will time out.
         * Amazon SWF will revert the override and schedule a new decision task to the original task list.
         * </p>
         * <p>
         * If a decision task scheduled on the override task list is started within the timeout, but not completed
         * within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task
         * to the original task list.
         * </p>
         * 
         * @param taskListScheduleToStartTimeout
         *        Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task
         *        list override is permanent. This parameter makes it possible to temporarily override the task list. If
         *        a decision task scheduled on the override task list is not started within the timeout, the decision
         *        task will time out. Amazon SWF will revert the override and schedule a new decision task to the
         *        original task list.</p>
         *        <p>
         *        If a decision task scheduled on the override task list is started within the timeout, but not
         *        completed within the start-to-close timeout, Amazon SWF will also revert the override and schedule a
         *        new decision task to the original task list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskListScheduleToStartTimeout(String taskListScheduleToStartTimeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String taskToken;

        private List<Decision> decisions = DefaultSdkAutoConstructList.getInstance();

        private String executionContext;

        private TaskList taskList;

        private String taskListScheduleToStartTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondDecisionTaskCompletedRequest model) {
            super(model);
            taskToken(model.taskToken);
            decisions(model.decisions);
            executionContext(model.executionContext);
            taskList(model.taskList);
            taskListScheduleToStartTimeout(model.taskListScheduleToStartTimeout);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final List<Decision.Builder> getDecisions() {
            List<Decision.Builder> result = DecisionListCopier.copyToBuilder(this.decisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDecisions(Collection<Decision.BuilderImpl> decisions) {
            this.decisions = DecisionListCopier.copyFromBuilder(decisions);
        }

        @Override
        public final Builder decisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Decision... decisions) {
            decisions(Arrays.asList(decisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Consumer<Decision.Builder>... decisions) {
            decisions(Stream.of(decisions).map(c -> Decision.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionContext() {
            return executionContext;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getTaskListScheduleToStartTimeout() {
            return taskListScheduleToStartTimeout;
        }

        public final void setTaskListScheduleToStartTimeout(String taskListScheduleToStartTimeout) {
            this.taskListScheduleToStartTimeout = taskListScheduleToStartTimeout;
        }

        @Override
        public final Builder taskListScheduleToStartTimeout(String taskListScheduleToStartTimeout) {
            this.taskListScheduleToStartTimeout = taskListScheduleToStartTimeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RespondDecisionTaskCompletedRequest build() {
            return new RespondDecisionTaskCompletedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
