/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprecateWorkflowTypeRequest extends SwfRequest implements
        ToCopyableBuilder<DeprecateWorkflowTypeRequest.Builder, DeprecateWorkflowTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(DeprecateWorkflowTypeRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .memberName("workflowType").getter(getter(DeprecateWorkflowTypeRequest::workflowType))
            .setter(setter(Builder::workflowType)).constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            WORKFLOW_TYPE_FIELD));

    private final String domain;

    private final WorkflowType workflowType;

    private DeprecateWorkflowTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.workflowType = builder.workflowType;
    }

    /**
     * <p>
     * The name of the domain in which the workflow type is registered.
     * </p>
     * 
     * @return The name of the domain in which the workflow type is registered.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflow type to deprecate.
     * </p>
     * 
     * @return The workflow type to deprecate.
     */
    public final WorkflowType workflowType() {
        return workflowType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateWorkflowTypeRequest)) {
            return false;
        }
        DeprecateWorkflowTypeRequest other = (DeprecateWorkflowTypeRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(workflowType(), other.workflowType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprecateWorkflowTypeRequest").add("Domain", domain()).add("WorkflowType", workflowType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeprecateWorkflowTypeRequest, T> g) {
        return obj -> g.apply((DeprecateWorkflowTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeprecateWorkflowTypeRequest> {
        /**
         * <p>
         * The name of the domain in which the workflow type is registered.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which the workflow type is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflow type to deprecate.
         * </p>
         * 
         * @param workflowType
         *        The workflow type to deprecate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The workflow type to deprecate.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowType.Builder} avoiding the need
         * to create one manually via {@link WorkflowType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private WorkflowType workflowType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateWorkflowTypeRequest model) {
            super(model);
            domain(model.domain);
            workflowType(model.workflowType);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeprecateWorkflowTypeRequest build() {
            return new DeprecateWorkflowTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
