/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventType {
    WORKFLOW_EXECUTION_STARTED("WorkflowExecutionStarted"),
    WORKFLOW_EXECUTION_CANCEL_REQUESTED("WorkflowExecutionCancelRequested"),
    WORKFLOW_EXECUTION_COMPLETED("WorkflowExecutionCompleted"),
    COMPLETE_WORKFLOW_EXECUTION_FAILED("CompleteWorkflowExecutionFailed"),
    WORKFLOW_EXECUTION_FAILED("WorkflowExecutionFailed"),
    FAIL_WORKFLOW_EXECUTION_FAILED("FailWorkflowExecutionFailed"),
    WORKFLOW_EXECUTION_TIMED_OUT("WorkflowExecutionTimedOut"),
    WORKFLOW_EXECUTION_CANCELED("WorkflowExecutionCanceled"),
    CANCEL_WORKFLOW_EXECUTION_FAILED("CancelWorkflowExecutionFailed"),
    WORKFLOW_EXECUTION_CONTINUED_AS_NEW("WorkflowExecutionContinuedAsNew"),
    CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED("ContinueAsNewWorkflowExecutionFailed"),
    WORKFLOW_EXECUTION_TERMINATED("WorkflowExecutionTerminated"),
    DECISION_TASK_SCHEDULED("DecisionTaskScheduled"),
    DECISION_TASK_STARTED("DecisionTaskStarted"),
    DECISION_TASK_COMPLETED("DecisionTaskCompleted"),
    DECISION_TASK_TIMED_OUT("DecisionTaskTimedOut"),
    ACTIVITY_TASK_SCHEDULED("ActivityTaskScheduled"),
    SCHEDULE_ACTIVITY_TASK_FAILED("ScheduleActivityTaskFailed"),
    ACTIVITY_TASK_STARTED("ActivityTaskStarted"),
    ACTIVITY_TASK_COMPLETED("ActivityTaskCompleted"),
    ACTIVITY_TASK_FAILED("ActivityTaskFailed"),
    ACTIVITY_TASK_TIMED_OUT("ActivityTaskTimedOut"),
    ACTIVITY_TASK_CANCELED("ActivityTaskCanceled"),
    ACTIVITY_TASK_CANCEL_REQUESTED("ActivityTaskCancelRequested"),
    REQUEST_CANCEL_ACTIVITY_TASK_FAILED("RequestCancelActivityTaskFailed"),
    WORKFLOW_EXECUTION_SIGNALED("WorkflowExecutionSignaled"),
    MARKER_RECORDED("MarkerRecorded"),
    RECORD_MARKER_FAILED("RecordMarkerFailed"),
    TIMER_STARTED("TimerStarted"),
    START_TIMER_FAILED("StartTimerFailed"),
    TIMER_FIRED("TimerFired"),
    TIMER_CANCELED("TimerCanceled"),
    CANCEL_TIMER_FAILED("CancelTimerFailed"),
    START_CHILD_WORKFLOW_EXECUTION_INITIATED("StartChildWorkflowExecutionInitiated"),
    START_CHILD_WORKFLOW_EXECUTION_FAILED("StartChildWorkflowExecutionFailed"),
    CHILD_WORKFLOW_EXECUTION_STARTED("ChildWorkflowExecutionStarted"),
    CHILD_WORKFLOW_EXECUTION_COMPLETED("ChildWorkflowExecutionCompleted"),
    CHILD_WORKFLOW_EXECUTION_FAILED("ChildWorkflowExecutionFailed"),
    CHILD_WORKFLOW_EXECUTION_TIMED_OUT("ChildWorkflowExecutionTimedOut"),
    CHILD_WORKFLOW_EXECUTION_CANCELED("ChildWorkflowExecutionCanceled"),
    CHILD_WORKFLOW_EXECUTION_TERMINATED("ChildWorkflowExecutionTerminated"),
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED("SignalExternalWorkflowExecutionInitiated"),
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED("SignalExternalWorkflowExecutionFailed"),
    EXTERNAL_WORKFLOW_EXECUTION_SIGNALED("ExternalWorkflowExecutionSignaled"),
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED("RequestCancelExternalWorkflowExecutionInitiated"),
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED("RequestCancelExternalWorkflowExecutionFailed"),
    EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED("ExternalWorkflowExecutionCancelRequested"),
    LAMBDA_FUNCTION_SCHEDULED("LambdaFunctionScheduled"),
    LAMBDA_FUNCTION_STARTED("LambdaFunctionStarted"),
    LAMBDA_FUNCTION_COMPLETED("LambdaFunctionCompleted"),
    LAMBDA_FUNCTION_FAILED("LambdaFunctionFailed"),
    LAMBDA_FUNCTION_TIMED_OUT("LambdaFunctionTimedOut"),
    SCHEDULE_LAMBDA_FUNCTION_FAILED("ScheduleLambdaFunctionFailed"),
    START_LAMBDA_FUNCTION_FAILED("StartLambdaFunctionFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
    }
}

