/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetRequest;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetResponse;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseResponse;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.services.support.model.CreateCaseResponse;
import software.amazon.awssdk.services.support.model.DescribeAttachmentRequest;
import software.amazon.awssdk.services.support.model.DescribeAttachmentResponse;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;
import software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsRequest;
import software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsResponse;
import software.amazon.awssdk.services.support.model.DescribeServicesRequest;
import software.amazon.awssdk.services.support.model.DescribeServicesResponse;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsRequest;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsResponse;
import software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesRequest;
import software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksResponse;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckRequest;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckResponse;
import software.amazon.awssdk.services.support.model.ResolveCaseRequest;
import software.amazon.awssdk.services.support.model.ResolveCaseResponse;
import software.amazon.awssdk.services.support.paginators.DescribeCasesPublisher;
import software.amazon.awssdk.services.support.paginators.DescribeCommunicationsPublisher;

/**
 * Service client for accessing AWS Support asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Web Services Support</fullname>
 * <p>
 * The <i>Amazon Web Services Support API Reference</i> is intended for programmers who need detailed information about
 * the Amazon Web Services Support operations and data types. You can use the API to manage your support cases
 * programmatically. The Amazon Web Services Support API uses HTTP methods that return results in JSON format.
 * </p>
 * <note>
 * <ul>
 * <li>
 * <p>
 * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or
 * Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about
 * changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.
 * </p>
 * </li>
 * </ul>
 * </note>
 * <p>
 * You can also use the Amazon Web Services Support API to access features for <a
 * href="http://aws.amazon.com/premiumsupport/trustedadvisor/">Trusted Advisor</a>. You can return a list of checks and
 * their descriptions, get check results, specify checks to refresh, and get the refresh status of checks.
 * </p>
 * <p>
 * You can manage your support cases with the following Amazon Web Services Support API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The <a>CreateCase</a>, <a>DescribeCases</a>, <a>DescribeAttachment</a>, and <a>ResolveCase</a> operations create
 * Amazon Web Services Support cases, retrieve information about cases, and resolve cases.
 * </p>
 * </li>
 * <li>
 * <p>
 * The <a>DescribeCommunications</a>, <a>AddCommunicationToCase</a>, and <a>AddAttachmentsToSet</a> operations retrieve
 * and add communications and attachments to Amazon Web Services Support cases.
 * </p>
 * </li>
 * <li>
 * <p>
 * The <a>DescribeServices</a> and <a>DescribeSeverityLevels</a> operations return Amazon Web Service names, service
 * codes, service categories, and problem severity levels. You use these values when you call the <a>CreateCase</a>
 * operation.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can also use the Amazon Web Services Support API to call the Trusted Advisor operations. For more information,
 * see <a href="https://docs.aws.amazon.com/">Trusted Advisor</a> in the <i>Amazon Web Services Support User Guide</i>.
 * </p>
 * <p>
 * For authentication of requests, Amazon Web Services Support uses <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
 * Process</a>.
 * </p>
 * <p>
 * For more information about this service and the endpoints to use, see <a
 * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html">About the Amazon Web Services
 * Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SupportAsyncClient extends AwsClient {
    String SERVICE_NAME = "support";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "support";

    /**
     * <p>
     * Adds one or more attachments to an attachment set.
     * </p>
     * <p>
     * An attachment set is a temporary container for attachments that you add to a case or case communication. The set
     * is available for 1 hour after it's created. The <code>expiryTime</code> returned in the response is when the set
     * expires.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param addAttachmentsToSetRequest
     * @return A Java Future containing the result of the AddAttachmentsToSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>AttachmentSetIdNotFoundException An attachment set with the specified ID could not be found.</li>
     *         <li>AttachmentSetExpiredException The expiration time of the attachment set has passed. The set expires 1
     *         hour after it is created.</li>
     *         <li>AttachmentSetSizeLimitExceededException A limit for the size of an attachment set has been exceeded.
     *         The limits are three attachments and 5 MB per attachment.</li>
     *         <li>AttachmentLimitExceededException The limit for the number of attachment sets created in a short
     *         period of time has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.AddAttachmentsToSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddAttachmentsToSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddAttachmentsToSetResponse> addAttachmentsToSet(
            AddAttachmentsToSetRequest addAttachmentsToSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more attachments to an attachment set.
     * </p>
     * <p>
     * An attachment set is a temporary container for attachments that you add to a case or case communication. The set
     * is available for 1 hour after it's created. The <code>expiryTime</code> returned in the response is when the set
     * expires.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddAttachmentsToSetRequest.Builder} avoiding the
     * need to create one manually via {@link AddAttachmentsToSetRequest#builder()}
     * </p>
     *
     * @param addAttachmentsToSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.AddAttachmentsToSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddAttachmentsToSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>AttachmentSetIdNotFoundException An attachment set with the specified ID could not be found.</li>
     *         <li>AttachmentSetExpiredException The expiration time of the attachment set has passed. The set expires 1
     *         hour after it is created.</li>
     *         <li>AttachmentSetSizeLimitExceededException A limit for the size of an attachment set has been exceeded.
     *         The limits are three attachments and 5 MB per attachment.</li>
     *         <li>AttachmentLimitExceededException The limit for the number of attachment sets created in a short
     *         period of time has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.AddAttachmentsToSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddAttachmentsToSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddAttachmentsToSetResponse> addAttachmentsToSet(
            Consumer<AddAttachmentsToSetRequest.Builder> addAttachmentsToSetRequest) {
        return addAttachmentsToSet(AddAttachmentsToSetRequest.builder().applyMutation(addAttachmentsToSetRequest).build());
    }

    /**
     * <p>
     * Adds additional customer communication to an Amazon Web Services Support case. Use the <code>caseId</code>
     * parameter to identify the case to which to add communication. You can list a set of email addresses to copy on
     * the communication by using the <code>ccEmailAddresses</code> parameter. The <code>communicationBody</code> value
     * contains the text of the communication.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param addCommunicationToCaseRequest
     * @return A Java Future containing the result of the AddCommunicationToCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>AttachmentSetIdNotFoundException An attachment set with the specified ID could not be found.</li>
     *         <li>AttachmentSetExpiredException The expiration time of the attachment set has passed. The set expires 1
     *         hour after it is created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.AddCommunicationToCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddCommunicationToCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCommunicationToCaseResponse> addCommunicationToCase(
            AddCommunicationToCaseRequest addCommunicationToCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds additional customer communication to an Amazon Web Services Support case. Use the <code>caseId</code>
     * parameter to identify the case to which to add communication. You can list a set of email addresses to copy on
     * the communication by using the <code>ccEmailAddresses</code> parameter. The <code>communicationBody</code> value
     * contains the text of the communication.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCommunicationToCaseRequest.Builder} avoiding the
     * need to create one manually via {@link AddCommunicationToCaseRequest#builder()}
     * </p>
     *
     * @param addCommunicationToCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddCommunicationToCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>AttachmentSetIdNotFoundException An attachment set with the specified ID could not be found.</li>
     *         <li>AttachmentSetExpiredException The expiration time of the attachment set has passed. The set expires 1
     *         hour after it is created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.AddCommunicationToCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddCommunicationToCase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCommunicationToCaseResponse> addCommunicationToCase(
            Consumer<AddCommunicationToCaseRequest.Builder> addCommunicationToCaseRequest) {
        return addCommunicationToCase(AddCommunicationToCaseRequest.builder().applyMutation(addCommunicationToCaseRequest)
                .build());
    }

    /**
     * <p>
     * Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in
     * the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create
     * Case</a> page.
     * </p>
     * <p>
     * The Amazon Web Services Support API doesn't support requesting service limit increases. You can submit a service
     * limit increase in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submit a request from the Amazon Web Services Support Center <a
     * href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Service Quotas <a
     * href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html"
     * >RequestServiceQuotaIncrease</a> operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A successful <code>CreateCase</code> request returns an Amazon Web Services Support case number. You can use the
     * <a>DescribeCases</a> operation and specify the case number to get existing Amazon Web Services Support cases.
     * After you create a case, use the <a>AddCommunicationToCase</a> operation to add additional communication or
     * attachments to an existing case.
     * </p>
     * <p>
     * The <code>caseId</code> is separate from the <code>displayId</code> that appears in the <a
     * href="https://console.aws.amazon.com/support">Amazon Web Services Support Center</a>. Use the
     * <a>DescribeCases</a> operation to get the <code>displayId</code>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createCaseRequest
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseCreationLimitExceededException The case creation limit for the account has been exceeded.</li>
     *         <li>AttachmentSetIdNotFoundException An attachment set with the specified ID could not be found.</li>
     *         <li>AttachmentSetExpiredException The expiration time of the attachment set has passed. The set expires 1
     *         hour after it is created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCaseResponse> createCase(CreateCaseRequest createCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in
     * the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create
     * Case</a> page.
     * </p>
     * <p>
     * The Amazon Web Services Support API doesn't support requesting service limit increases. You can submit a service
     * limit increase in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submit a request from the Amazon Web Services Support Center <a
     * href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Service Quotas <a
     * href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html"
     * >RequestServiceQuotaIncrease</a> operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A successful <code>CreateCase</code> request returns an Amazon Web Services Support case number. You can use the
     * <a>DescribeCases</a> operation and specify the case number to get existing Amazon Web Services Support cases.
     * After you create a case, use the <a>AddCommunicationToCase</a> operation to add additional communication or
     * attachments to an existing case.
     * </p>
     * <p>
     * The <code>caseId</code> is separate from the <code>displayId</code> that appears in the <a
     * href="https://console.aws.amazon.com/support">Amazon Web Services Support Center</a>. Use the
     * <a>DescribeCases</a> operation to get the <code>displayId</code>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCaseRequest#builder()}
     * </p>
     *
     * @param createCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.CreateCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseCreationLimitExceededException The case creation limit for the account has been exceeded.</li>
     *         <li>AttachmentSetIdNotFoundException An attachment set with the specified ID could not be found.</li>
     *         <li>AttachmentSetExpiredException The expiration time of the attachment set has passed. The set expires 1
     *         hour after it is created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCaseResponse> createCase(Consumer<CreateCaseRequest.Builder> createCaseRequest) {
        return createCase(CreateCaseRequest.builder().applyMutation(createCaseRequest).build());
    }

    /**
     * <p>
     * Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files
     * that describe your issue. Attachment IDs are generated by the case management system when you add an attachment
     * to a case or case communication. Attachment IDs are returned in the <a>AttachmentDetails</a> objects that are
     * returned by the <a>DescribeCommunications</a> operation.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeAttachmentRequest
     * @return A Java Future containing the result of the DescribeAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>DescribeAttachmentLimitExceededException The limit for the number of <a>DescribeAttachment</a>
     *         requests in a short period of time has been exceeded.</li>
     *         <li>AttachmentIdNotFoundException An attachment with the specified ID could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeAttachment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAttachmentResponse> describeAttachment(DescribeAttachmentRequest describeAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files
     * that describe your issue. Attachment IDs are generated by the case management system when you add an attachment
     * to a case or case communication. Attachment IDs are returned in the <a>AttachmentDetails</a> objects that are
     * returned by the <a>DescribeCommunications</a> operation.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttachmentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAttachmentRequest#builder()}
     * </p>
     *
     * @param describeAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>DescribeAttachmentLimitExceededException The limit for the number of <a>DescribeAttachment</a>
     *         requests in a short period of time has been exceeded.</li>
     *         <li>AttachmentIdNotFoundException An attachment with the specified ID could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeAttachment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAttachmentResponse> describeAttachment(
            Consumer<DescribeAttachmentRequest.Builder> describeAttachmentRequest) {
        return describeAttachment(DescribeAttachmentRequest.builder().applyMutation(describeAttachmentRequest).build());
    }

    /**
     * <p>
     * Returns a list of cases that you specify by passing one or more case IDs. You can use the <code>afterTime</code>
     * and <code>beforeTime</code> parameters to filter the cases by date. You can set values for the
     * <code>includeResolvedCases</code> and <code>includeCommunications</code> parameters to specify how much
     * information to return.
     * </p>
     * <p>
     * The response returns the following in JSON format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more <a
     * href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more <code>nextToken</code> values, which specify where to paginate the returned records represented by
     * the <code>CaseDetails</code> objects.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request
     * might return an error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeCasesRequest
     * @return A Java Future containing the result of the DescribeCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCasesResponse> describeCases(DescribeCasesRequest describeCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of cases that you specify by passing one or more case IDs. You can use the <code>afterTime</code>
     * and <code>beforeTime</code> parameters to filter the cases by date. You can set values for the
     * <code>includeResolvedCases</code> and <code>includeCommunications</code> parameters to specify how much
     * information to return.
     * </p>
     * <p>
     * The response returns the following in JSON format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more <a
     * href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more <code>nextToken</code> values, which specify where to paginate the returned records represented by
     * the <code>CaseDetails</code> objects.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request
     * might return an error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCasesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeCasesRequest#builder()}
     * </p>
     *
     * @param describeCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeCasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCasesResponse> describeCases(Consumer<DescribeCasesRequest.Builder> describeCasesRequest) {
        return describeCases(DescribeCasesRequest.builder().applyMutation(describeCasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of cases that you specify by passing one or more case IDs. You can use the <code>afterTime</code>
     * and <code>beforeTime</code> parameters to filter the cases by date. You can set values for the
     * <code>includeResolvedCases</code> and <code>includeCommunications</code> parameters to specify how much
     * information to return.
     * </p>
     * <p>
     * The response returns the following in JSON format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more <a
     * href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more <code>nextToken</code> values, which specify where to paginate the returned records represented by
     * the <code>CaseDetails</code> objects.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request
     * might return an error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeCases(software.amazon.awssdk.services.support.model.DescribeCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCasesPublisher publisher = client.describeCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCasesPublisher publisher = client.describeCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.support.model.DescribeCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.support.model.DescribeCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCases(software.amazon.awssdk.services.support.model.DescribeCasesRequest)} operation.</b>
     * </p>
     *
     * @param describeCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCasesPublisher describeCasesPaginator(DescribeCasesRequest describeCasesRequest) {
        return new DescribeCasesPublisher(this, describeCasesRequest);
    }

    /**
     * <p>
     * Returns a list of cases that you specify by passing one or more case IDs. You can use the <code>afterTime</code>
     * and <code>beforeTime</code> parameters to filter the cases by date. You can set values for the
     * <code>includeResolvedCases</code> and <code>includeCommunications</code> parameters to specify how much
     * information to return.
     * </p>
     * <p>
     * The response returns the following in JSON format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more <a
     * href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more <code>nextToken</code> values, which specify where to paginate the returned records represented by
     * the <code>CaseDetails</code> objects.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request
     * might return an error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeCases(software.amazon.awssdk.services.support.model.DescribeCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCasesPublisher publisher = client.describeCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCasesPublisher publisher = client.describeCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.support.model.DescribeCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.support.model.DescribeCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCases(software.amazon.awssdk.services.support.model.DescribeCasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCasesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeCasesRequest#builder()}
     * </p>
     *
     * @param describeCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeCasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCasesPublisher describeCasesPaginator(Consumer<DescribeCasesRequest.Builder> describeCasesRequest) {
        return describeCasesPaginator(DescribeCasesRequest.builder().applyMutation(describeCasesRequest).build());
    }

    /**
     * <p>
     * Returns communications and attachments for one or more support cases. Use the <code>afterTime</code> and
     * <code>beforeTime</code> parameters to filter by date. You can use the <code>caseId</code> parameter to restrict
     * the results to a specific case.
     * </p>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for
     * data might cause an error.
     * </p>
     * <p>
     * You can use the <code>maxResults</code> and <code>nextToken</code> parameters to control the pagination of the
     * results. Set <code>maxResults</code> to the number of cases that you want to display on each page, and use
     * <code>nextToken</code> to specify the resumption of pagination.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeCommunicationsRequest
     * @return A Java Future containing the result of the DescribeCommunications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCommunications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCommunications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCommunicationsResponse> describeCommunications(
            DescribeCommunicationsRequest describeCommunicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns communications and attachments for one or more support cases. Use the <code>afterTime</code> and
     * <code>beforeTime</code> parameters to filter by date. You can use the <code>caseId</code> parameter to restrict
     * the results to a specific case.
     * </p>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for
     * data might cause an error.
     * </p>
     * <p>
     * You can use the <code>maxResults</code> and <code>nextToken</code> parameters to control the pagination of the
     * results. Set <code>maxResults</code> to the number of cases that you want to display on each page, and use
     * <code>nextToken</code> to specify the resumption of pagination.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCommunicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCommunicationsRequest#builder()}
     * </p>
     *
     * @param describeCommunicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCommunications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCommunications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCommunications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCommunicationsResponse> describeCommunications(
            Consumer<DescribeCommunicationsRequest.Builder> describeCommunicationsRequest) {
        return describeCommunications(DescribeCommunicationsRequest.builder().applyMutation(describeCommunicationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns communications and attachments for one or more support cases. Use the <code>afterTime</code> and
     * <code>beforeTime</code> parameters to filter by date. You can use the <code>caseId</code> parameter to restrict
     * the results to a specific case.
     * </p>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for
     * data might cause an error.
     * </p>
     * <p>
     * You can use the <code>maxResults</code> and <code>nextToken</code> parameters to control the pagination of the
     * results. Set <code>maxResults</code> to the number of cases that you want to display on each page, and use
     * <code>nextToken</code> to specify the resumption of pagination.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeCommunications(software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCommunicationsPublisher publisher = client.describeCommunicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCommunicationsPublisher publisher = client.describeCommunicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCommunications(software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCommunicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCommunications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCommunications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCommunicationsPublisher describeCommunicationsPaginator(
            DescribeCommunicationsRequest describeCommunicationsRequest) {
        return new DescribeCommunicationsPublisher(this, describeCommunicationsRequest);
    }

    /**
     * <p>
     * Returns communications and attachments for one or more support cases. Use the <code>afterTime</code> and
     * <code>beforeTime</code> parameters to filter by date. You can use the <code>caseId</code> parameter to restrict
     * the results to a specific case.
     * </p>
     * <p>
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for
     * data might cause an error.
     * </p>
     * <p>
     * You can use the <code>maxResults</code> and <code>nextToken</code> parameters to control the pagination of the
     * results. Set <code>maxResults</code> to the number of cases that you want to display on each page, and use
     * <code>nextToken</code> to specify the resumption of pagination.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeCommunications(software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCommunicationsPublisher publisher = client.describeCommunicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.support.paginators.DescribeCommunicationsPublisher publisher = client.describeCommunicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCommunications(software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCommunicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCommunicationsRequest#builder()}
     * </p>
     *
     * @param describeCommunicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCommunications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCommunications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCommunicationsPublisher describeCommunicationsPaginator(
            Consumer<DescribeCommunicationsRequest.Builder> describeCommunicationsRequest) {
        return describeCommunicationsPaginator(DescribeCommunicationsRequest.builder()
                .applyMutation(describeCommunicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of CreateCaseOption types along with the corresponding supported hours and language availability.
     * You can specify the <code>language</code> <code>categoryCode</code>, <code>issueType</code> and
     * <code>serviceCode</code> used to retrieve the CreateCaseOptions.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeCreateCaseOptionsRequest
     * @return A Java Future containing the result of the DescribeCreateCaseOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCreateCaseOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCreateCaseOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCreateCaseOptionsResponse> describeCreateCaseOptions(
            DescribeCreateCaseOptionsRequest describeCreateCaseOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of CreateCaseOption types along with the corresponding supported hours and language availability.
     * You can specify the <code>language</code> <code>categoryCode</code>, <code>issueType</code> and
     * <code>serviceCode</code> used to retrieve the CreateCaseOptions.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCreateCaseOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCreateCaseOptionsRequest#builder()}
     * </p>
     *
     * @param describeCreateCaseOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeCreateCaseOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCreateCaseOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeCreateCaseOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCreateCaseOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCreateCaseOptionsResponse> describeCreateCaseOptions(
            Consumer<DescribeCreateCaseOptionsRequest.Builder> describeCreateCaseOptionsRequest) {
        return describeCreateCaseOptions(DescribeCreateCaseOptionsRequest.builder()
                .applyMutation(describeCreateCaseOptionsRequest).build());
    }

    /**
     * <p>
     * Returns the current list of Amazon Web Services services and a list of service categories for each service. You
     * then use service names and categories in your <a>CreateCase</a> requests. Each Amazon Web Services service has
     * its own set of categories.
     * </p>
     * <p>
     * The service codes and category codes correspond to the values that appear in the <b>Service</b> and
     * <b>Category</b> lists on the Amazon Web Services Support Center <a
     * href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. The values in those fields
     * don't necessarily match the service codes and categories returned by the <code>DescribeServices</code> operation.
     * Always use the service codes and categories that the <code>DescribeServices</code> operation returns, so that you
     * have the most recent set of service and category codes.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeServicesRequest
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices(DescribeServicesRequest describeServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current list of Amazon Web Services services and a list of service categories for each service. You
     * then use service names and categories in your <a>CreateCase</a> requests. Each Amazon Web Services service has
     * its own set of categories.
     * </p>
     * <p>
     * The service codes and category codes correspond to the values that appear in the <b>Service</b> and
     * <b>Category</b> lists on the Amazon Web Services Support Center <a
     * href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. The values in those fields
     * don't necessarily match the service codes and categories returned by the <code>DescribeServices</code> operation.
     * Always use the service codes and categories that the <code>DescribeServices</code> operation returns, so that you
     * have the most recent set of service and category codes.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServicesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeServicesRequest#builder()}
     * </p>
     *
     * @param describeServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices(
            Consumer<DescribeServicesRequest.Builder> describeServicesRequest) {
        return describeServices(DescribeServicesRequest.builder().applyMutation(describeServicesRequest).build());
    }

    /**
     * <p>
     * Returns the list of severity levels that you can assign to a support case. The severity level for a case is also
     * a field in the <a>CaseDetails</a> data type that you include for a <a>CreateCase</a> request.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeSeverityLevelsRequest
     * @return A Java Future containing the result of the DescribeSeverityLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeSeverityLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSeverityLevelsResponse> describeSeverityLevels(
            DescribeSeverityLevelsRequest describeSeverityLevelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of severity levels that you can assign to a support case. The severity level for a case is also
     * a field in the <a>CaseDetails</a> data type that you include for a <a>CreateCase</a> request.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSeverityLevelsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSeverityLevelsRequest#builder()}
     * </p>
     *
     * @param describeSeverityLevelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeSeverityLevelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSeverityLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeSeverityLevels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSeverityLevelsResponse> describeSeverityLevels(
            Consumer<DescribeSeverityLevelsRequest.Builder> describeSeverityLevelsRequest) {
        return describeSeverityLevels(DescribeSeverityLevelsRequest.builder().applyMutation(describeSeverityLevelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of supported languages for a specified <code>categoryCode</code>, <code>issueType</code> and
     * <code>serviceCode</code>. The returned supported languages will include a ISO 639-1 code for the
     * <code>language</code>, and the language display name.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeSupportedLanguagesRequest
     * @return A Java Future containing the result of the DescribeSupportedLanguages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeSupportedLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSupportedLanguages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSupportedLanguagesResponse> describeSupportedLanguages(
            DescribeSupportedLanguagesRequest describeSupportedLanguagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of supported languages for a specified <code>categoryCode</code>, <code>issueType</code> and
     * <code>serviceCode</code>. The returned supported languages will include a ISO 639-1 code for the
     * <code>language</code>, and the language display name.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSupportedLanguagesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSupportedLanguagesRequest#builder()}
     * </p>
     *
     * @param describeSupportedLanguagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeSupportedLanguagesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeSupportedLanguages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeSupportedLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSupportedLanguages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSupportedLanguagesResponse> describeSupportedLanguages(
            Consumer<DescribeSupportedLanguagesRequest.Builder> describeSupportedLanguagesRequest) {
        return describeSupportedLanguages(DescribeSupportedLanguagesRequest.builder()
                .applyMutation(describeSupportedLanguagesRequest).build());
    }

    /**
     * <p>
     * Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check
     * IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * Some checks are refreshed automatically, and you can't return their refresh statuses by using the
     * <code>DescribeTrustedAdvisorCheckRefreshStatuses</code> operation. If you call this operation for these checks,
     * you might see an <code>InvalidParameterValue</code> error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     *
     * @param describeTrustedAdvisorCheckRefreshStatusesRequest
     * @return A Java Future containing the result of the DescribeTrustedAdvisorCheckRefreshStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorCheckRefreshStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckRefreshStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorCheckRefreshStatusesResponse> describeTrustedAdvisorCheckRefreshStatuses(
            DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check
     * IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * Some checks are refreshed automatically, and you can't return their refresh statuses by using the
     * <code>DescribeTrustedAdvisorCheckRefreshStatuses</code> operation. If you call this operation for these checks,
     * you might see an <code>InvalidParameterValue</code> error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeTrustedAdvisorCheckRefreshStatusesRequest#builder()}
     * </p>
     *
     * @param describeTrustedAdvisorCheckRefreshStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTrustedAdvisorCheckRefreshStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorCheckRefreshStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckRefreshStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorCheckRefreshStatusesResponse> describeTrustedAdvisorCheckRefreshStatuses(
            Consumer<DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder> describeTrustedAdvisorCheckRefreshStatusesRequest) {
        return describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest.builder()
                .applyMutation(describeTrustedAdvisorCheckRefreshStatusesRequest).build());
    }

    /**
     * <p>
     * Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by
     * calling the <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * The response contains a <a>TrustedAdvisorCheckResult</a> object, which contains these three objects:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>TrustedAdvisorCategorySpecificSummary</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>TrustedAdvisorResourceDetail</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>TrustedAdvisorResourcesSummary</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In addition, the response contains these fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>status</b> - The alert status of the check can be <code>ok</code> (green), <code>warning</code> (yellow),
     * <code>error</code> (red), or <code>not_available</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>timestamp</b> - The time of the last refresh of the check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>checkId</b> - The unique identifier for the check.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     *
     * @param describeTrustedAdvisorCheckResultRequest
     * @return A Java Future containing the result of the DescribeTrustedAdvisorCheckResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorCheckResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorCheckResultResponse> describeTrustedAdvisorCheckResult(
            DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by
     * calling the <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * The response contains a <a>TrustedAdvisorCheckResult</a> object, which contains these three objects:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>TrustedAdvisorCategorySpecificSummary</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>TrustedAdvisorResourceDetail</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>TrustedAdvisorResourcesSummary</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In addition, the response contains these fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>status</b> - The alert status of the check can be <code>ok</code> (green), <code>warning</code> (yellow),
     * <code>error</code> (red), or <code>not_available</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>timestamp</b> - The time of the last refresh of the check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>checkId</b> - The unique identifier for the check.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustedAdvisorCheckResultRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrustedAdvisorCheckResultRequest#builder()}
     * </p>
     *
     * @param describeTrustedAdvisorCheckResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTrustedAdvisorCheckResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorCheckResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorCheckResultResponse> describeTrustedAdvisorCheckResult(
            Consumer<DescribeTrustedAdvisorCheckResultRequest.Builder> describeTrustedAdvisorCheckResultRequest) {
        return describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest.builder()
                .applyMutation(describeTrustedAdvisorCheckResultRequest).build());
    }

    /**
     * <p>
     * Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the
     * check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * The response contains an array of <a>TrustedAdvisorCheckSummary</a> objects.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     *
     * @param describeTrustedAdvisorCheckSummariesRequest
     * @return A Java Future containing the result of the DescribeTrustedAdvisorCheckSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorCheckSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorCheckSummariesResponse> describeTrustedAdvisorCheckSummaries(
            DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the
     * check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * The response contains an array of <a>TrustedAdvisorCheckSummary</a> objects.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeTrustedAdvisorCheckSummariesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeTrustedAdvisorCheckSummariesRequest#builder()}
     * </p>
     *
     * @param describeTrustedAdvisorCheckSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTrustedAdvisorCheckSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorCheckSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorCheckSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorCheckSummariesResponse> describeTrustedAdvisorCheckSummaries(
            Consumer<DescribeTrustedAdvisorCheckSummariesRequest.Builder> describeTrustedAdvisorCheckSummariesRequest) {
        return describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest.builder()
                .applyMutation(describeTrustedAdvisorCheckSummariesRequest).build());
    }

    /**
     * <p>
     * Returns information about all available Trusted Advisor checks, including the name, ID, category, description,
     * and metadata. You must specify a language code.
     * </p>
     * <p>
     * The response contains a <a>TrustedAdvisorCheckDescription</a> object for each check. You must set the Amazon Web
     * Services Region to us-east-1.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the
     * check ID in your code to uniquely identify a check.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     *
     * @param describeTrustedAdvisorChecksRequest
     * @return A Java Future containing the result of the DescribeTrustedAdvisorChecks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorChecksResponse> describeTrustedAdvisorChecks(
            DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all available Trusted Advisor checks, including the name, ID, category, description,
     * and metadata. You must specify a language code.
     * </p>
     * <p>
     * The response contains a <a>TrustedAdvisorCheckDescription</a> object for each check. You must set the Amazon Web
     * Services Region to us-east-1.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the
     * check ID in your code to uniquely identify a check.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustedAdvisorChecksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrustedAdvisorChecksRequest#builder()}
     * </p>
     *
     * @param describeTrustedAdvisorChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTrustedAdvisorChecks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>ThrottlingException You have exceeded the maximum allowed TPS (Transactions Per Second) for the
     *         operations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.DescribeTrustedAdvisorChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeTrustedAdvisorChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustedAdvisorChecksResponse> describeTrustedAdvisorChecks(
            Consumer<DescribeTrustedAdvisorChecksRequest.Builder> describeTrustedAdvisorChecksRequest) {
        return describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest.builder()
                .applyMutation(describeTrustedAdvisorChecksRequest).build());
    }

    /**
     * <p>
     * Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the
     * <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * Some checks are refreshed automatically. If you call the <code>RefreshTrustedAdvisorCheck</code> operation to
     * refresh them, you might see the <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * The response contains a <a>TrustedAdvisorCheckRefreshStatus</a> object.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     *
     * @param refreshTrustedAdvisorCheckRequest
     * @return A Java Future containing the result of the RefreshTrustedAdvisorCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.RefreshTrustedAdvisorCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/RefreshTrustedAdvisorCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RefreshTrustedAdvisorCheckResponse> refreshTrustedAdvisorCheck(
            RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the
     * <a>DescribeTrustedAdvisorChecks</a> operation.
     * </p>
     * <p>
     * Some checks are refreshed automatically. If you call the <code>RefreshTrustedAdvisorCheck</code> operation to
     * refresh them, you might see the <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * The response contains a <a>TrustedAdvisorCheckRefreshStatus</a> object.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N.
     * Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted
     * Advisor operations. For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint">About the Amazon Web
     * Services Support API</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshTrustedAdvisorCheckRequest.Builder} avoiding
     * the need to create one manually via {@link RefreshTrustedAdvisorCheckRequest#builder()}
     * </p>
     *
     * @param refreshTrustedAdvisorCheckRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RefreshTrustedAdvisorCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.RefreshTrustedAdvisorCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/RefreshTrustedAdvisorCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RefreshTrustedAdvisorCheckResponse> refreshTrustedAdvisorCheck(
            Consumer<RefreshTrustedAdvisorCheckRequest.Builder> refreshTrustedAdvisorCheckRequest) {
        return refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest.builder()
                .applyMutation(refreshTrustedAdvisorCheckRequest).build());
    }

    /**
     * <p>
     * Resolves a support case. This operation takes a <code>caseId</code> and returns the initial and final state of
     * the case.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param resolveCaseRequest
     * @return A Java Future containing the result of the ResolveCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.ResolveCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/ResolveCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResolveCaseResponse> resolveCase(ResolveCaseRequest resolveCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resolves a support case. This operation takes a <code>caseId</code> and returns the initial and final state of
     * the case.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp,
     * or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information
     * about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services
     * Support</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveCaseRequest.Builder} avoiding the need to
     * create one manually via {@link ResolveCaseRequest#builder()}
     * </p>
     *
     * @param resolveCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.support.model.ResolveCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResolveCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>CaseIdNotFoundException The requested <code>caseId</code> couldn't be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SupportException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SupportAsyncClient.ResolveCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/ResolveCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResolveCaseResponse> resolveCase(Consumer<ResolveCaseRequest.Builder> resolveCaseRequest) {
        return resolveCase(ResolveCaseRequest.builder().applyMutation(resolveCaseRequest).build());
    }

    @Override
    default SupportServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SupportAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SupportAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SupportAsyncClient}.
     */
    static SupportAsyncClientBuilder builder() {
        return new DefaultSupportAsyncClientBuilder();
    }
}
