/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceAccessControlAttributeConfigurationResponse extends SsoAdminResponse
        implements
        ToCopyableBuilder<DescribeInstanceAccessControlAttributeConfigurationResponse.Builder, DescribeInstanceAccessControlAttributeConfigurationResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeInstanceAccessControlAttributeConfigurationResponse::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DescribeInstanceAccessControlAttributeConfigurationResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<InstanceAccessControlAttributeConfiguration> INSTANCE_ACCESS_CONTROL_ATTRIBUTE_CONFIGURATION_FIELD = SdkField
            .<InstanceAccessControlAttributeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceAccessControlAttributeConfiguration")
            .getter(getter(DescribeInstanceAccessControlAttributeConfigurationResponse::instanceAccessControlAttributeConfiguration))
            .setter(setter(Builder::instanceAccessControlAttributeConfiguration))
            .constructor(InstanceAccessControlAttributeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceAccessControlAttributeConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, INSTANCE_ACCESS_CONTROL_ATTRIBUTE_CONFIGURATION_FIELD));

    private final String status;

    private final String statusReason;

    private final InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration;

    private DescribeInstanceAccessControlAttributeConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.instanceAccessControlAttributeConfiguration = builder.instanceAccessControlAttributeConfiguration;
    }

    /**
     * <p>
     * The status of the attribute configuration process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceAccessControlAttributeConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the attribute configuration process.
     * @see InstanceAccessControlAttributeConfigurationStatus
     */
    public final InstanceAccessControlAttributeConfigurationStatus status() {
        return InstanceAccessControlAttributeConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the attribute configuration process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceAccessControlAttributeConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the attribute configuration process.
     * @see InstanceAccessControlAttributeConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides more details about the current status of the specified attribute.
     * </p>
     * 
     * @return Provides more details about the current status of the specified attribute.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Gets the list of IAM Identity Center identity store attributes that have been added to your ABAC configuration.
     * </p>
     * 
     * @return Gets the list of IAM Identity Center identity store attributes that have been added to your ABAC
     *         configuration.
     */
    public final InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration() {
        return instanceAccessControlAttributeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(instanceAccessControlAttributeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAccessControlAttributeConfigurationResponse)) {
            return false;
        }
        DescribeInstanceAccessControlAttributeConfigurationResponse other = (DescribeInstanceAccessControlAttributeConfigurationResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(instanceAccessControlAttributeConfiguration(),
                        other.instanceAccessControlAttributeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceAccessControlAttributeConfigurationResponse").add("Status", statusAsString())
                .add("StatusReason", statusReason())
                .add("InstanceAccessControlAttributeConfiguration", instanceAccessControlAttributeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "InstanceAccessControlAttributeConfiguration":
            return Optional.ofNullable(clazz.cast(instanceAccessControlAttributeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAccessControlAttributeConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeInstanceAccessControlAttributeConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceAccessControlAttributeConfigurationResponse> {
        /**
         * <p>
         * The status of the attribute configuration process.
         * </p>
         * 
         * @param status
         *        The status of the attribute configuration process.
         * @see InstanceAccessControlAttributeConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessControlAttributeConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the attribute configuration process.
         * </p>
         * 
         * @param status
         *        The status of the attribute configuration process.
         * @see InstanceAccessControlAttributeConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessControlAttributeConfigurationStatus
         */
        Builder status(InstanceAccessControlAttributeConfigurationStatus status);

        /**
         * <p>
         * Provides more details about the current status of the specified attribute.
         * </p>
         * 
         * @param statusReason
         *        Provides more details about the current status of the specified attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Gets the list of IAM Identity Center identity store attributes that have been added to your ABAC
         * configuration.
         * </p>
         * 
         * @param instanceAccessControlAttributeConfiguration
         *        Gets the list of IAM Identity Center identity store attributes that have been added to your ABAC
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAccessControlAttributeConfiguration(
                InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration);

        /**
         * <p>
         * Gets the list of IAM Identity Center identity store attributes that have been added to your ABAC
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceAccessControlAttributeConfiguration.Builder} avoiding the need to create one manually via
         * {@link InstanceAccessControlAttributeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceAccessControlAttributeConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration)}.
         * 
         * @param instanceAccessControlAttributeConfiguration
         *        a consumer that will call methods on {@link InstanceAccessControlAttributeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration)
         */
        default Builder instanceAccessControlAttributeConfiguration(
                Consumer<InstanceAccessControlAttributeConfiguration.Builder> instanceAccessControlAttributeConfiguration) {
            return instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration.builder()
                    .applyMutation(instanceAccessControlAttributeConfiguration).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAccessControlAttributeConfigurationResponse model) {
            super(model);
            status(model.status);
            statusReason(model.statusReason);
            instanceAccessControlAttributeConfiguration(model.instanceAccessControlAttributeConfiguration);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceAccessControlAttributeConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final InstanceAccessControlAttributeConfiguration.Builder getInstanceAccessControlAttributeConfiguration() {
            return instanceAccessControlAttributeConfiguration != null ? instanceAccessControlAttributeConfiguration.toBuilder()
                    : null;
        }

        public final void setInstanceAccessControlAttributeConfiguration(
                InstanceAccessControlAttributeConfiguration.BuilderImpl instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration != null ? instanceAccessControlAttributeConfiguration
                    .build() : null;
        }

        @Override
        public final Builder instanceAccessControlAttributeConfiguration(
                InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration;
            return this;
        }

        @Override
        public DescribeInstanceAccessControlAttributeConfigurationResponse build() {
            return new DescribeInstanceAccessControlAttributeConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
