/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ssoadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ConflictException;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.InternalServerException;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssoadmin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminException;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ThrottlingException;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ValidationException;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.ssoadmin.transform.AttachCustomerManagedPolicyReferenceToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.AttachManagedPolicyToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateAccountAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreatePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteAccountAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInlinePolicyFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeletePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeletePermissionsBoundaryFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeAccountAssignmentCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeAccountAssignmentDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribePermissionSetProvisioningStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DetachCustomerManagedPolicyReferenceFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DetachManagedPolicyFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetInlinePolicyForPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetPermissionsBoundaryForPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountsForProvisionedPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListCustomerManagedPolicyReferencesInPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListManagedPoliciesInPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetProvisioningStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetsProvisionedToAccountRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ProvisionPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutInlinePolicyToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutPermissionsBoundaryToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdateInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdatePermissionSetRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link SsoAdminClient}.
 *
 * @see SsoAdminClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSsoAdminClient implements SsoAdminClient {
    private static final Logger log = Logger.loggerFor(DefaultSsoAdminClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final SsoAdminServiceClientConfiguration serviceClientConfiguration;

    protected DefaultSsoAdminClient(SsoAdminServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.
     * </p>
     *
     * @param attachCustomerManagedPolicyReferenceToPermissionSetRequest
     * @return Result of the AttachCustomerManagedPolicyReferenceToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.AttachCustomerManagedPolicyReferenceToPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AttachCustomerManagedPolicyReferenceToPermissionSetResponse attachCustomerManagedPolicyReferenceToPermissionSet(
            AttachCustomerManagedPolicyReferenceToPermissionSetRequest attachCustomerManagedPolicyReferenceToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachCustomerManagedPolicyReferenceToPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AttachCustomerManagedPolicyReferenceToPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachCustomerManagedPolicyReferenceToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachCustomerManagedPolicyReferenceToPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<AttachCustomerManagedPolicyReferenceToPermissionSetRequest, AttachCustomerManagedPolicyReferenceToPermissionSetResponse>()
                            .withOperationName("AttachCustomerManagedPolicyReferenceToPermissionSet")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachCustomerManagedPolicyReferenceToPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new AttachCustomerManagedPolicyReferenceToPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an AWS managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code>
     * applies the corresponding IAM policy updates to all assigned accounts.
     * </p>
     * </note>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     * @return Result of the AttachManagedPolicyToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.AttachManagedPolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AttachManagedPolicyToPermissionSetResponse attachManagedPolicyToPermissionSet(
            AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachManagedPolicyToPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AttachManagedPolicyToPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachManagedPolicyToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachManagedPolicyToPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<AttachManagedPolicyToPermissionSetRequest, AttachManagedPolicyToPermissionSetResponse>()
                            .withOperationName("AttachManagedPolicyToPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(attachManagedPolicyToPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AttachManagedPolicyToPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns access to a principal for a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role
     * created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies
     * attached to roles in your accounts will not be updated automatically. In this case, you must call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note> <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment creation request.
     * </p>
     * </note>
     *
     * @param createAccountAssignmentRequest
     * @return Result of the CreateAccountAssignment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreateAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountAssignmentResponse createAccountAssignment(CreateAccountAssignmentRequest createAccountAssignmentRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountAssignmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountAssignmentRequest, CreateAccountAssignmentResponse>()
                            .withOperationName("CreateAccountAssignment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createAccountAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You
     * can also specify new attributes to add to your ABAC configuration during the enabling process. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeInstanceAccessControlAttributeConfiguration</code> to validate
     * that <code>InstanceAccessControlAttributeConfiguration</code> was created.
     * </p>
     * </note>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the CreateInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInstanceAccessControlAttributeConfigurationResponse createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest createInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateInstanceAccessControlAttributeConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceAccessControlAttributeConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceAccessControlAttributeConfigurationRequest, CreateInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("CreateInstanceAccessControlAttributeConfiguration")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstanceAccessControlAttributeConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new CreateInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a permission set within a specified IAM Identity Center instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to AWS account resources, use <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note>
     *
     * @param createPermissionSetRequest
     * @return Result of the CreatePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePermissionSetResponse createPermissionSet(CreatePermissionSetRequest createPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePermissionSet");

            return clientHandler.execute(new ClientExecutionParams<CreatePermissionSetRequest, CreatePermissionSetResponse>()
                    .withOperationName("CreatePermissionSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPermissionSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a principal's access from a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment deletion request.
     * </p>
     * </note>
     *
     * @param deleteAccountAssignmentRequest
     * @return Result of the DeleteAccountAssignment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountAssignmentResponse deleteAccountAssignment(DeleteAccountAssignmentRequest deleteAccountAssignmentRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountAssignmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAssignmentRequest, DeleteAccountAssignmentResponse>()
                            .withOperationName("DeleteAccountAssignment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccountAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     * @return Result of the DeleteInlinePolicyFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInlinePolicyFromPermissionSetResponse deleteInlinePolicyFromPermissionSet(
            DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInlinePolicyFromPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInlinePolicyFromPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInlinePolicyFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInlinePolicyFromPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInlinePolicyFromPermissionSetRequest, DeleteInlinePolicyFromPermissionSetResponse>()
                            .withOperationName("DeleteInlinePolicyFromPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteInlinePolicyFromPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInlinePolicyFromPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and
     * deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received
     * from an identity source and any custom attributes you have previously configured will not be passed. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the DeleteInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInstanceAccessControlAttributeConfigurationResponse deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest deleteInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteInstanceAccessControlAttributeConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceAccessControlAttributeConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceAccessControlAttributeConfigurationRequest, DeleteInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("DeleteInstanceAccessControlAttributeConfiguration")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteInstanceAccessControlAttributeConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DeleteInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     *
     * @param deletePermissionSetRequest
     * @return Result of the DeletePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeletePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeletePermissionSetResponse deletePermissionSet(DeletePermissionSetRequest deletePermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePermissionSet");

            return clientHandler.execute(new ClientExecutionParams<DeletePermissionSetRequest, DeletePermissionSetResponse>()
                    .withOperationName("DeletePermissionSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePermissionSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the permissions boundary from a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param deletePermissionsBoundaryFromPermissionSetRequest
     * @return Result of the DeletePermissionsBoundaryFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeletePermissionsBoundaryFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePermissionsBoundaryFromPermissionSetResponse deletePermissionsBoundaryFromPermissionSet(
            DeletePermissionsBoundaryFromPermissionSetRequest deletePermissionsBoundaryFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePermissionsBoundaryFromPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeletePermissionsBoundaryFromPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deletePermissionsBoundaryFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePermissionsBoundaryFromPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<DeletePermissionsBoundaryFromPermissionSetRequest, DeletePermissionsBoundaryFromPermissionSetResponse>()
                            .withOperationName("DeletePermissionsBoundaryFromPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deletePermissionsBoundaryFromPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeletePermissionsBoundaryFromPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     * @return Result of the DescribeAccountAssignmentCreationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountAssignmentCreationStatusResponse describeAccountAssignmentCreationStatus(
            DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountAssignmentCreationStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeAccountAssignmentCreationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccountAssignmentCreationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAssignmentCreationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAssignmentCreationStatusRequest, DescribeAccountAssignmentCreationStatusResponse>()
                            .withOperationName("DescribeAccountAssignmentCreationStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAccountAssignmentCreationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountAssignmentCreationStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     * @return Result of the DescribeAccountAssignmentDeletionStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountAssignmentDeletionStatusResponse describeAccountAssignmentDeletionStatus(
            DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountAssignmentDeletionStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeAccountAssignmentDeletionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccountAssignmentDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAssignmentDeletionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAssignmentDeletionStatusRequest, DescribeAccountAssignmentDeletionStatusResponse>()
                            .withOperationName("DescribeAccountAssignmentDeletionStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAccountAssignmentDeletionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountAssignmentDeletionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with
     * attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return
     * attributes configured and sent by an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center
     * User Guide</i>.
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the DescribeInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceAccessControlAttributeConfigurationResponse describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest describeInstanceAccessControlAttributeConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeInstanceAccessControlAttributeConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceAccessControlAttributeConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceAccessControlAttributeConfigurationRequest, DescribeInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("DescribeInstanceAccessControlAttributeConfiguration")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceAccessControlAttributeConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DescribeInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     *
     * @param describePermissionSetRequest
     * @return Result of the DescribePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePermissionSetResponse describePermissionSet(DescribePermissionSetRequest describePermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePermissionSet");

            return clientHandler.execute(new ClientExecutionParams<DescribePermissionSetRequest, DescribePermissionSetResponse>()
                    .withOperationName("DescribePermissionSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePermissionSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     * @return Result of the DescribePermissionSetProvisioningStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePermissionSetProvisioningStatusResponse describePermissionSetProvisioningStatus(
            DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePermissionSetProvisioningStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribePermissionSetProvisioningStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePermissionSetProvisioningStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePermissionSetProvisioningStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePermissionSetProvisioningStatusRequest, DescribePermissionSetProvisioningStatusResponse>()
                            .withOperationName("DescribePermissionSetProvisioningStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePermissionSetProvisioningStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePermissionSetProvisioningStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.
     * </p>
     *
     * @param detachCustomerManagedPolicyReferenceFromPermissionSetRequest
     * @return Result of the DetachCustomerManagedPolicyReferenceFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DetachCustomerManagedPolicyReferenceFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetachCustomerManagedPolicyReferenceFromPermissionSetResponse detachCustomerManagedPolicyReferenceFromPermissionSet(
            DetachCustomerManagedPolicyReferenceFromPermissionSetRequest detachCustomerManagedPolicyReferenceFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetachCustomerManagedPolicyReferenceFromPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DetachCustomerManagedPolicyReferenceFromPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                detachCustomerManagedPolicyReferenceFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "DetachCustomerManagedPolicyReferenceFromPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<DetachCustomerManagedPolicyReferenceFromPermissionSetRequest, DetachCustomerManagedPolicyReferenceFromPermissionSetResponse>()
                            .withOperationName("DetachCustomerManagedPolicyReferenceFromPermissionSet")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachCustomerManagedPolicyReferenceFromPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DetachCustomerManagedPolicyReferenceFromPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches the attached AWS managed policy ARN from the specified permission set.
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     * @return Result of the DetachManagedPolicyFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetachManagedPolicyFromPermissionSetResponse detachManagedPolicyFromPermissionSet(
            DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetachManagedPolicyFromPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DetachManagedPolicyFromPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                detachManagedPolicyFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachManagedPolicyFromPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<DetachManagedPolicyFromPermissionSetRequest, DetachManagedPolicyFromPermissionSetResponse>()
                            .withOperationName("DetachManagedPolicyFromPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachManagedPolicyFromPermissionSetRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DetachManagedPolicyFromPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     * @return Result of the GetInlinePolicyForPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.GetInlinePolicyForPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInlinePolicyForPermissionSetResponse getInlinePolicyForPermissionSet(
            GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInlinePolicyForPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInlinePolicyForPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInlinePolicyForPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInlinePolicyForPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<GetInlinePolicyForPermissionSetRequest, GetInlinePolicyForPermissionSetResponse>()
                            .withOperationName("GetInlinePolicyForPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getInlinePolicyForPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetInlinePolicyForPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains the permissions boundary for a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param getPermissionsBoundaryForPermissionSetRequest
     * @return Result of the GetPermissionsBoundaryForPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.GetPermissionsBoundaryForPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPermissionsBoundaryForPermissionSetResponse getPermissionsBoundaryForPermissionSet(
            GetPermissionsBoundaryForPermissionSetRequest getPermissionsBoundaryForPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPermissionsBoundaryForPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetPermissionsBoundaryForPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPermissionsBoundaryForPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPermissionsBoundaryForPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPermissionsBoundaryForPermissionSetRequest, GetPermissionsBoundaryForPermissionSetResponse>()
                            .withOperationName("GetPermissionsBoundaryForPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getPermissionsBoundaryForPermissionSetRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPermissionsBoundaryForPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return Result of the ListAccountAssignmentCreationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssignmentCreationStatusResponse listAccountAssignmentCreationStatus(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountAssignmentCreationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccountAssignmentCreationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccountAssignmentCreationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentCreationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssignmentCreationStatusRequest, ListAccountAssignmentCreationStatusResponse>()
                            .withOperationName("ListAccountAssignmentCreationStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAccountAssignmentCreationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAccountAssignmentCreationStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client.listAccountAssignmentCreationStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client
     *             .listAccountAssignmentCreationStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client.listAccountAssignmentCreationStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssignmentCreationStatusIterable listAccountAssignmentCreationStatusPaginator(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListAccountAssignmentCreationStatusIterable(this,
                applyPaginatorUserAgent(listAccountAssignmentCreationStatusRequest));
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return Result of the ListAccountAssignmentDeletionStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssignmentDeletionStatusResponse listAccountAssignmentDeletionStatus(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountAssignmentDeletionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccountAssignmentDeletionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccountAssignmentDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentDeletionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssignmentDeletionStatusRequest, ListAccountAssignmentDeletionStatusResponse>()
                            .withOperationName("ListAccountAssignmentDeletionStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAccountAssignmentDeletionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAccountAssignmentDeletionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client.listAccountAssignmentDeletionStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client
     *             .listAccountAssignmentDeletionStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client.listAccountAssignmentDeletionStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssignmentDeletionStatusIterable listAccountAssignmentDeletionStatusPaginator(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListAccountAssignmentDeletionStatusIterable(this,
                applyPaginatorUserAgent(listAccountAssignmentDeletionStatusRequest));
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return Result of the ListAccountAssignments operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssignmentsResponse listAccountAssignments(ListAccountAssignmentsRequest listAccountAssignmentsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountAssignmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccountAssignmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAssignmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignments");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssignmentsRequest, ListAccountAssignmentsResponse>()
                            .withOperationName("ListAccountAssignments").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAccountAssignmentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAccountAssignmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client.listAccountAssignmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client
     *             .listAccountAssignmentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client.listAccountAssignmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssignmentsIterable listAccountAssignmentsPaginator(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return new ListAccountAssignmentsIterable(this, applyPaginatorUserAgent(listAccountAssignmentsRequest));
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return Result of the ListAccountsForProvisionedPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountsForProvisionedPermissionSetResponse listAccountsForProvisionedPermissionSet(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountsForProvisionedPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListAccountsForProvisionedPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccountsForProvisionedPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountsForProvisionedPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAccountsForProvisionedPermissionSetRequest, ListAccountsForProvisionedPermissionSetResponse>()
                            .withOperationName("ListAccountsForProvisionedPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAccountsForProvisionedPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAccountsForProvisionedPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client
     *             .listAccountsForProvisionedPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountsForProvisionedPermissionSetIterable listAccountsForProvisionedPermissionSetPaginator(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListAccountsForProvisionedPermissionSetIterable(this,
                applyPaginatorUserAgent(listAccountsForProvisionedPermissionSetRequest));
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     * @return Result of the ListCustomerManagedPolicyReferencesInPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomerManagedPolicyReferencesInPermissionSetResponse listCustomerManagedPolicyReferencesInPermissionSet(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomerManagedPolicyReferencesInPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListCustomerManagedPolicyReferencesInPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomerManagedPolicyReferencesInPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomerManagedPolicyReferencesInPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomerManagedPolicyReferencesInPermissionSetRequest, ListCustomerManagedPolicyReferencesInPermissionSetResponse>()
                            .withOperationName("ListCustomerManagedPolicyReferencesInPermissionSet")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCustomerManagedPolicyReferencesInPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new ListCustomerManagedPolicyReferencesInPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client
     *             .listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomerManagedPolicyReferencesInPermissionSetIterable listCustomerManagedPolicyReferencesInPermissionSetPaginator(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListCustomerManagedPolicyReferencesInPermissionSetIterable(this,
                applyPaginatorUserAgent(listCustomerManagedPolicyReferencesInPermissionSetRequest));
    }

    /**
     * <p>
     * Lists the IAM Identity Center instances that the caller has access to.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInstancesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstances");

            return clientHandler.execute(new ClientExecutionParams<ListInstancesRequest, ListInstancesResponse>()
                    .withOperationName("ListInstances").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM Identity Center instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return new ListInstancesIterable(this, applyPaginatorUserAgent(listInstancesRequest));
    }

    /**
     * <p>
     * Lists the AWS managed policy that is attached to a specified permission set.
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return Result of the ListManagedPoliciesInPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListManagedPoliciesInPermissionSetResponse listManagedPoliciesInPermissionSet(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedPoliciesInPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedPoliciesInPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listManagedPoliciesInPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedPoliciesInPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<ListManagedPoliciesInPermissionSetRequest, ListManagedPoliciesInPermissionSetResponse>()
                            .withOperationName("ListManagedPoliciesInPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listManagedPoliciesInPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListManagedPoliciesInPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the AWS managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client.listManagedPoliciesInPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client
     *             .listManagedPoliciesInPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client.listManagedPoliciesInPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListManagedPoliciesInPermissionSetIterable listManagedPoliciesInPermissionSetPaginator(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListManagedPoliciesInPermissionSetIterable(this,
                applyPaginatorUserAgent(listManagedPoliciesInPermissionSetRequest));
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return Result of the ListPermissionSetProvisioningStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPermissionSetProvisioningStatusResponse listPermissionSetProvisioningStatus(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPermissionSetProvisioningStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPermissionSetProvisioningStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPermissionSetProvisioningStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSetProvisioningStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPermissionSetProvisioningStatusRequest, ListPermissionSetProvisioningStatusResponse>()
                            .withOperationName("ListPermissionSetProvisioningStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPermissionSetProvisioningStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPermissionSetProvisioningStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client.listPermissionSetProvisioningStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client
     *             .listPermissionSetProvisioningStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client.listPermissionSetProvisioningStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPermissionSetProvisioningStatusIterable listPermissionSetProvisioningStatusPaginator(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListPermissionSetProvisioningStatusIterable(this,
                applyPaginatorUserAgent(listPermissionSetProvisioningStatusRequest));
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return Result of the ListPermissionSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPermissionSetsResponse listPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPermissionSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPermissionSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPermissionSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSets");

            return clientHandler.execute(new ClientExecutionParams<ListPermissionSetsRequest, ListPermissionSetsResponse>()
                    .withOperationName("ListPermissionSets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPermissionSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPermissionSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client.listPermissionSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client
     *             .listPermissionSetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client.listPermissionSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPermissionSetsIterable listPermissionSetsPaginator(ListPermissionSetsRequest listPermissionSetsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListPermissionSetsIterable(this, applyPaginatorUserAgent(listPermissionSetsRequest));
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return Result of the ListPermissionSetsProvisionedToAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPermissionSetsProvisionedToAccountResponse listPermissionSetsProvisionedToAccount(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPermissionSetsProvisionedToAccountResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListPermissionSetsProvisionedToAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPermissionSetsProvisionedToAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSetsProvisionedToAccount");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPermissionSetsProvisionedToAccountRequest, ListPermissionSetsProvisionedToAccountResponse>()
                            .withOperationName("ListPermissionSetsProvisionedToAccount").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPermissionSetsProvisionedToAccountRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPermissionSetsProvisionedToAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client
     *             .listPermissionSetsProvisionedToAccountPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPermissionSetsProvisionedToAccountIterable listPermissionSetsProvisionedToAccountPaginator(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListPermissionSetsProvisionedToAccountIterable(this,
                applyPaginatorUserAgent(listPermissionSetsProvisionedToAccountRequest));
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return new ListTagsForResourceIterable(this, applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     *
     * @param provisionPermissionSetRequest
     * @return Result of the ProvisionPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ProvisionPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ProvisionPermissionSetResponse provisionPermissionSet(ProvisionPermissionSetRequest provisionPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ProvisionPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ProvisionPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, provisionPermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<ProvisionPermissionSetRequest, ProvisionPermissionSetResponse>()
                            .withOperationName("ProvisionPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(provisionPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ProvisionPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note>
     *
     * @param putInlinePolicyToPermissionSetRequest
     * @return Result of the PutInlinePolicyToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.PutInlinePolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutInlinePolicyToPermissionSetResponse putInlinePolicyToPermissionSet(
            PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutInlinePolicyToPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutInlinePolicyToPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putInlinePolicyToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInlinePolicyToPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<PutInlinePolicyToPermissionSetRequest, PutInlinePolicyToPermissionSetResponse>()
                            .withOperationName("PutInlinePolicyToPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putInlinePolicyToPermissionSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutInlinePolicyToPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an AWS managed or customer managed policy to the specified <a>PermissionSet</a> as a permissions
     * boundary.
     * </p>
     *
     * @param putPermissionsBoundaryToPermissionSetRequest
     * @return Result of the PutPermissionsBoundaryToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.PutPermissionsBoundaryToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutPermissionsBoundaryToPermissionSetResponse putPermissionsBoundaryToPermissionSet(
            PutPermissionsBoundaryToPermissionSetRequest putPermissionsBoundaryToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutPermissionsBoundaryToPermissionSetResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, PutPermissionsBoundaryToPermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putPermissionsBoundaryToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPermissionsBoundaryToPermissionSet");

            return clientHandler
                    .execute(new ClientExecutionParams<PutPermissionsBoundaryToPermissionSetRequest, PutPermissionsBoundaryToPermissionSetResponse>()
                            .withOperationName("PutPermissionsBoundaryToPermissionSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(putPermissionsBoundaryToPermissionSetRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutPermissionsBoundaryToPermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance
     * for attributes-based access control (ABAC). When using an external identity provider as an identity source, you
     * can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity
     * Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the
     * attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see
     * <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity
     * Center User Guide</i>.
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the UpdateInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateInstanceAccessControlAttributeConfigurationResponse updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest updateInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateInstanceAccessControlAttributeConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInstanceAccessControlAttributeConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateInstanceAccessControlAttributeConfigurationRequest, UpdateInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("UpdateInstanceAccessControlAttributeConfiguration")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateInstanceAccessControlAttributeConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new UpdateInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     *
     * @param updatePermissionSetRequest
     * @return Result of the UpdatePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UpdatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdatePermissionSetResponse updatePermissionSet(UpdatePermissionSetRequest updatePermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePermissionSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePermissionSet");

            return clientHandler.execute(new ClientExecutionParams<UpdatePermissionSetRequest, UpdatePermissionSetResponse>()
                    .withOperationName("UpdatePermissionSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePermissionSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePermissionSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private <T extends SsoAdminRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SsoAdminException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public final SsoAdminServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
