/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.model.EventSummary;
import software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsResponse;

public class ListTimelineEventsPublisher
implements SdkPublisher<ListTimelineEventsResponse> {
    private final SsmIncidentsAsyncClient client;
    private final ListTimelineEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTimelineEventsPublisher(SsmIncidentsAsyncClient client, ListTimelineEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTimelineEventsPublisher(SsmIncidentsAsyncClient client, ListTimelineEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTimelineEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTimelineEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventSummary> eventSummaries() {
        Function<ListTimelineEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSummaries() != null) {
                return response.eventSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTimelineEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTimelineEventsResponseFetcher
    implements AsyncPageFetcher<ListTimelineEventsResponse> {
        private ListTimelineEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListTimelineEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTimelineEventsResponse> nextPage(ListTimelineEventsResponse previousPage) {
            if (previousPage == null) {
                return ListTimelineEventsPublisher.this.client.listTimelineEvents(ListTimelineEventsPublisher.this.firstRequest);
            }
            return ListTimelineEventsPublisher.this.client.listTimelineEvents((ListTimelineEventsRequest)((Object)ListTimelineEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

