/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssmincidents.DefaultSsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.DefaultSsmIncidentsBaseClientBuilder;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClientBuilder;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsServiceClientConfiguration;
import software.amazon.awssdk.services.ssmincidents.endpoints.SsmIncidentsEndpointProvider;

@SdkInternalApi
final class DefaultSsmIncidentsAsyncClientBuilder
extends DefaultSsmIncidentsBaseClientBuilder<SsmIncidentsAsyncClientBuilder, SsmIncidentsAsyncClient>
implements SsmIncidentsAsyncClientBuilder {
    DefaultSsmIncidentsAsyncClientBuilder() {
    }

    @Override
    public DefaultSsmIncidentsAsyncClientBuilder endpointProvider(SsmIncidentsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmIncidentsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSsmIncidentsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SsmIncidentsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsmIncidentsAsyncClient client = new DefaultSsmIncidentsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsmIncidentsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsmIncidentsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

