/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details used when updating the replication set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReplicationSetAction implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateReplicationSetAction.Builder, UpdateReplicationSetAction> {
    private static final SdkField<AddRegionAction> ADD_REGION_ACTION_FIELD = SdkField
            .<AddRegionAction> builder(MarshallingType.SDK_POJO).memberName("addRegionAction")
            .getter(getter(UpdateReplicationSetAction::addRegionAction)).setter(setter(Builder::addRegionAction))
            .constructor(AddRegionAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addRegionAction").build()).build();

    private static final SdkField<DeleteRegionAction> DELETE_REGION_ACTION_FIELD = SdkField
            .<DeleteRegionAction> builder(MarshallingType.SDK_POJO).memberName("deleteRegionAction")
            .getter(getter(UpdateReplicationSetAction::deleteRegionAction)).setter(setter(Builder::deleteRegionAction))
            .constructor(DeleteRegionAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteRegionAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_REGION_ACTION_FIELD,
            DELETE_REGION_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AddRegionAction addRegionAction;

    private final DeleteRegionAction deleteRegionAction;

    private final Type type;

    private UpdateReplicationSetAction(BuilderImpl builder) {
        this.addRegionAction = builder.addRegionAction;
        this.deleteRegionAction = builder.deleteRegionAction;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about the Amazon Web Services Region that you're adding to the replication set.
     * </p>
     * 
     * @return Details about the Amazon Web Services Region that you're adding to the replication set.
     */
    public final AddRegionAction addRegionAction() {
        return addRegionAction;
    }

    /**
     * <p>
     * Details about the Amazon Web Services Region that you're deleting to the replication set.
     * </p>
     * 
     * @return Details about the Amazon Web Services Region that you're deleting to the replication set.
     */
    public final DeleteRegionAction deleteRegionAction() {
        return deleteRegionAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addRegionAction());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRegionAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationSetAction)) {
            return false;
        }
        UpdateReplicationSetAction other = (UpdateReplicationSetAction) obj;
        return Objects.equals(addRegionAction(), other.addRegionAction())
                && Objects.equals(deleteRegionAction(), other.deleteRegionAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReplicationSetAction").add("AddRegionAction", addRegionAction())
                .add("DeleteRegionAction", deleteRegionAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addRegionAction":
            return Optional.ofNullable(clazz.cast(addRegionAction()));
        case "deleteRegionAction":
            return Optional.ofNullable(clazz.cast(deleteRegionAction()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addRegionAction()} initialized to the given value.
     *
     * <p>
     * Details about the Amazon Web Services Region that you're adding to the replication set.
     * </p>
     * 
     * @param addRegionAction
     *        Details about the Amazon Web Services Region that you're adding to the replication set.
     */
    public static UpdateReplicationSetAction fromAddRegionAction(AddRegionAction addRegionAction) {
        return builder().addRegionAction(addRegionAction).build();
    }

    /**
     * Create an instance of this class with {@link #addRegionAction()} initialized to the given value.
     *
     * <p>
     * Details about the Amazon Web Services Region that you're adding to the replication set.
     * </p>
     * 
     * @param addRegionAction
     *        Details about the Amazon Web Services Region that you're adding to the replication set.
     */
    public static UpdateReplicationSetAction fromAddRegionAction(Consumer<AddRegionAction.Builder> addRegionAction) {
        AddRegionAction.Builder builder = AddRegionAction.builder();
        addRegionAction.accept(builder);
        return fromAddRegionAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteRegionAction()} initialized to the given value.
     *
     * <p>
     * Details about the Amazon Web Services Region that you're deleting to the replication set.
     * </p>
     * 
     * @param deleteRegionAction
     *        Details about the Amazon Web Services Region that you're deleting to the replication set.
     */
    public static UpdateReplicationSetAction fromDeleteRegionAction(DeleteRegionAction deleteRegionAction) {
        return builder().deleteRegionAction(deleteRegionAction).build();
    }

    /**
     * Create an instance of this class with {@link #deleteRegionAction()} initialized to the given value.
     *
     * <p>
     * Details about the Amazon Web Services Region that you're deleting to the replication set.
     * </p>
     * 
     * @param deleteRegionAction
     *        Details about the Amazon Web Services Region that you're deleting to the replication set.
     */
    public static UpdateReplicationSetAction fromDeleteRegionAction(Consumer<DeleteRegionAction.Builder> deleteRegionAction) {
        DeleteRegionAction.Builder builder = DeleteRegionAction.builder();
        deleteRegionAction.accept(builder);
        return fromDeleteRegionAction(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationSetAction, T> g) {
        return obj -> g.apply((UpdateReplicationSetAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateReplicationSetAction> {
        /**
         * <p>
         * Details about the Amazon Web Services Region that you're adding to the replication set.
         * </p>
         * 
         * @param addRegionAction
         *        Details about the Amazon Web Services Region that you're adding to the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRegionAction(AddRegionAction addRegionAction);

        /**
         * <p>
         * Details about the Amazon Web Services Region that you're adding to the replication set.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddRegionAction.Builder} avoiding the
         * need to create one manually via {@link AddRegionAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddRegionAction.Builder#build()} is called immediately and its
         * result is passed to {@link #addRegionAction(AddRegionAction)}.
         * 
         * @param addRegionAction
         *        a consumer that will call methods on {@link AddRegionAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addRegionAction(AddRegionAction)
         */
        default Builder addRegionAction(Consumer<AddRegionAction.Builder> addRegionAction) {
            return addRegionAction(AddRegionAction.builder().applyMutation(addRegionAction).build());
        }

        /**
         * <p>
         * Details about the Amazon Web Services Region that you're deleting to the replication set.
         * </p>
         * 
         * @param deleteRegionAction
         *        Details about the Amazon Web Services Region that you're deleting to the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRegionAction(DeleteRegionAction deleteRegionAction);

        /**
         * <p>
         * Details about the Amazon Web Services Region that you're deleting to the replication set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteRegionAction.Builder} avoiding the
         * need to create one manually via {@link DeleteRegionAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteRegionAction.Builder#build()} is called immediately and its
         * result is passed to {@link #deleteRegionAction(DeleteRegionAction)}.
         * 
         * @param deleteRegionAction
         *        a consumer that will call methods on {@link DeleteRegionAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteRegionAction(DeleteRegionAction)
         */
        default Builder deleteRegionAction(Consumer<DeleteRegionAction.Builder> deleteRegionAction) {
            return deleteRegionAction(DeleteRegionAction.builder().applyMutation(deleteRegionAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddRegionAction addRegionAction;

        private DeleteRegionAction deleteRegionAction;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationSetAction model) {
            addRegionAction(model.addRegionAction);
            deleteRegionAction(model.deleteRegionAction);
        }

        public final AddRegionAction.Builder getAddRegionAction() {
            return addRegionAction != null ? addRegionAction.toBuilder() : null;
        }

        public final void setAddRegionAction(AddRegionAction.BuilderImpl addRegionAction) {
            Object oldValue = this.addRegionAction;
            this.addRegionAction = addRegionAction != null ? addRegionAction.build() : null;
            handleUnionValueChange(Type.ADD_REGION_ACTION, oldValue, this.addRegionAction);
        }

        @Override
        public final Builder addRegionAction(AddRegionAction addRegionAction) {
            Object oldValue = this.addRegionAction;
            this.addRegionAction = addRegionAction;
            handleUnionValueChange(Type.ADD_REGION_ACTION, oldValue, this.addRegionAction);
            return this;
        }

        public final DeleteRegionAction.Builder getDeleteRegionAction() {
            return deleteRegionAction != null ? deleteRegionAction.toBuilder() : null;
        }

        public final void setDeleteRegionAction(DeleteRegionAction.BuilderImpl deleteRegionAction) {
            Object oldValue = this.deleteRegionAction;
            this.deleteRegionAction = deleteRegionAction != null ? deleteRegionAction.build() : null;
            handleUnionValueChange(Type.DELETE_REGION_ACTION, oldValue, this.deleteRegionAction);
        }

        @Override
        public final Builder deleteRegionAction(DeleteRegionAction deleteRegionAction) {
            Object oldValue = this.deleteRegionAction;
            this.deleteRegionAction = deleteRegionAction;
            handleUnionValueChange(Type.DELETE_REGION_ACTION, oldValue, this.deleteRegionAction);
            return this;
        }

        @Override
        public UpdateReplicationSetAction build() {
            return new UpdateReplicationSetAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdateReplicationSetAction#type()
     */
    public enum Type {
        ADD_REGION_ACTION,

        DELETE_REGION_ACTION,

        UNKNOWN_TO_SDK_VERSION
    }
}
