/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIncidentRecordRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<UpdateIncidentRecordRequest.Builder, UpdateIncidentRecordRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateIncidentRecordRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.<ChatChannel> builder(MarshallingType.SDK_POJO)
            .memberName("chatChannel").getter(getter(UpdateIncidentRecordRequest::chatChannel))
            .setter(setter(Builder::chatChannel)).constructor(ChatChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateIncidentRecordRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> IMPACT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("impact").getter(getter(UpdateIncidentRecordRequest::impact)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()).build();

    private static final SdkField<List<NotificationTargetItem>> NOTIFICATION_TARGETS_FIELD = SdkField
            .<List<NotificationTargetItem>> builder(MarshallingType.LIST)
            .memberName("notificationTargets")
            .getter(getter(UpdateIncidentRecordRequest::notificationTargets))
            .setter(setter(Builder::notificationTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationTargetItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationTargetItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateIncidentRecordRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("summary")
            .getter(getter(UpdateIncidentRecordRequest::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(UpdateIncidentRecordRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHAT_CHANNEL_FIELD,
            CLIENT_TOKEN_FIELD, IMPACT_FIELD, NOTIFICATION_TARGETS_FIELD, STATUS_FIELD, SUMMARY_FIELD, TITLE_FIELD));

    private final String arn;

    private final ChatChannel chatChannel;

    private final String clientToken;

    private final Integer impact;

    private final List<NotificationTargetItem> notificationTargets;

    private final String status;

    private final String summary;

    private final String title;

    private UpdateIncidentRecordRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.chatChannel = builder.chatChannel;
        this.clientToken = builder.clientToken;
        this.impact = builder.impact;
        this.notificationTargets = builder.notificationTargets;
        this.status = builder.status;
        this.summary = builder.summary;
        this.title = builder.title;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident record you are updating.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident record you are updating.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Chatbot chat channel where responders can collaborate.
     * </p>
     * 
     * @return The Chatbot chat channel where responders can collaborate.
     */
    public final ChatChannel chatChannel() {
        return chatChannel;
    }

    /**
     * <p>
     * A token that ensures that a client calls the operation only once with the specified details.
     * </p>
     * 
     * @return A token that ensures that a client calls the operation only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Defines the impact of the incident to customers and applications. If you provide an impact for an incident, it
     * overwrites the impact provided by the response plan.
     * </p>
     * <p class="title">
     * <b>Possible impacts:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>1</code> - Critical impact, full application failure that impacts many to all customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>2</code> - High impact, partial application failure with impact to many customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>3</code> - Medium impact, the application is providing reduced service to customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>4</code> - Low impact, customer aren't impacted by the problem yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Defines the impact of the incident to customers and applications. If you provide an impact for an
     *         incident, it overwrites the impact provided by the response plan.</p>
     *         <p class="title">
     *         <b>Possible impacts:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>1</code> - Critical impact, full application failure that impacts many to all customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>2</code> - High impact, partial application failure with impact to many customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>3</code> - Medium impact, the application is providing reduced service to customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>4</code> - Low impact, customer aren't impacted by the problem yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid
     *         impact.
     *         </p>
     *         </li>
     */
    public final Integer impact() {
        return impact;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationTargets() {
        return notificationTargets != null && !(notificationTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon SNS targets that Incident Manager notifies when a client updates an incident.
     * </p>
     * <p>
     * Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationTargets} method.
     * </p>
     * 
     * @return The Amazon SNS targets that Incident Manager notifies when a client updates an incident.</p>
     *         <p>
     *         Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
     */
    public final List<NotificationTargetItem> notificationTargets() {
        return notificationTargets;
    }

    /**
     * <p>
     * The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IncidentRecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
     * @see IncidentRecordStatus
     */
    public final IncidentRecordStatus status() {
        return IncidentRecordStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IncidentRecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
     * @see IncidentRecordStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A longer description of what occurred during the incident.
     * </p>
     * 
     * @return A longer description of what occurred during the incident.
     */
    public final String summary() {
        return summary;
    }

    /**
     * <p>
     * A brief description of the incident.
     * </p>
     * 
     * @return A brief description of the incident.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(impact());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationTargets() ? notificationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIncidentRecordRequest)) {
            return false;
        }
        UpdateIncidentRecordRequest other = (UpdateIncidentRecordRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(chatChannel(), other.chatChannel())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(impact(), other.impact())
                && hasNotificationTargets() == other.hasNotificationTargets()
                && Objects.equals(notificationTargets(), other.notificationTargets())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(summary(), other.summary())
                && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIncidentRecordRequest").add("Arn", arn()).add("ChatChannel", chatChannel())
                .add("ClientToken", clientToken()).add("Impact", impact())
                .add("NotificationTargets", hasNotificationTargets() ? notificationTargets() : null)
                .add("Status", statusAsString()).add("Summary", summary()).add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "chatChannel":
            return Optional.ofNullable(clazz.cast(chatChannel()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "impact":
            return Optional.ofNullable(clazz.cast(impact()));
        case "notificationTargets":
            return Optional.ofNullable(clazz.cast(notificationTargets()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIncidentRecordRequest, T> g) {
        return obj -> g.apply((UpdateIncidentRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIncidentRecordRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident record you are updating.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the incident record you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Chatbot chat channel where responders can collaborate.
         * </p>
         * 
         * @param chatChannel
         *        The Chatbot chat channel where responders can collaborate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatChannel(ChatChannel chatChannel);

        /**
         * <p>
         * The Chatbot chat channel where responders can collaborate.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatChannel.Builder} avoiding the need to
         * create one manually via {@link ChatChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatChannel.Builder#build()} is called immediately and its result
         * is passed to {@link #chatChannel(ChatChannel)}.
         * 
         * @param chatChannel
         *        a consumer that will call methods on {@link ChatChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatChannel(ChatChannel)
         */
        default Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return chatChannel(ChatChannel.builder().applyMutation(chatChannel).build());
        }

        /**
         * <p>
         * A token that ensures that a client calls the operation only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures that a client calls the operation only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Defines the impact of the incident to customers and applications. If you provide an impact for an incident,
         * it overwrites the impact provided by the response plan.
         * </p>
         * <p class="title">
         * <b>Possible impacts:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>1</code> - Critical impact, full application failure that impacts many to all customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>2</code> - High impact, partial application failure with impact to many customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>3</code> - Medium impact, the application is providing reduced service to customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>4</code> - Low impact, customer aren't impacted by the problem yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
         * </p>
         * </li>
         * </ul>
         * 
         * @param impact
         *        Defines the impact of the incident to customers and applications. If you provide an impact for an
         *        incident, it overwrites the impact provided by the response plan.</p>
         *        <p class="title">
         *        <b>Possible impacts:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>1</code> - Critical impact, full application failure that impacts many to all customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>2</code> - High impact, partial application failure with impact to many customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>3</code> - Medium impact, the application is providing reduced service to customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>4</code> - Low impact, customer aren't impacted by the problem yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid
         *        impact.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impact(Integer impact);

        /**
         * <p>
         * The Amazon SNS targets that Incident Manager notifies when a client updates an incident.
         * </p>
         * <p>
         * Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
         * </p>
         * 
         * @param notificationTargets
         *        The Amazon SNS targets that Incident Manager notifies when a client updates an incident.</p>
         *        <p>
         *        Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTargets(Collection<NotificationTargetItem> notificationTargets);

        /**
         * <p>
         * The Amazon SNS targets that Incident Manager notifies when a client updates an incident.
         * </p>
         * <p>
         * Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
         * </p>
         * 
         * @param notificationTargets
         *        The Amazon SNS targets that Incident Manager notifies when a client updates an incident.</p>
         *        <p>
         *        Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTargets(NotificationTargetItem... notificationTargets);

        /**
         * <p>
         * The Amazon SNS targets that Incident Manager notifies when a client updates an incident.
         * </p>
         * <p>
         * Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationTargets(List<NotificationTargetItem>)}.
         * 
         * @param notificationTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationTargets(java.util.Collection<NotificationTargetItem>)
         */
        Builder notificationTargets(Consumer<NotificationTargetItem.Builder>... notificationTargets);

        /**
         * <p>
         * The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
         * </p>
         * 
         * @param status
         *        The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
         * @see IncidentRecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncidentRecordStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
         * </p>
         * 
         * @param status
         *        The status of the incident. Possible statuses are <code>Open</code> or <code>Resolved</code>.
         * @see IncidentRecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncidentRecordStatus
         */
        Builder status(IncidentRecordStatus status);

        /**
         * <p>
         * A longer description of what occurred during the incident.
         * </p>
         * 
         * @param summary
         *        A longer description of what occurred during the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);

        /**
         * <p>
         * A brief description of the incident.
         * </p>
         * 
         * @param title
         *        A brief description of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private String arn;

        private ChatChannel chatChannel;

        private String clientToken;

        private Integer impact;

        private List<NotificationTargetItem> notificationTargets = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String summary;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIncidentRecordRequest model) {
            super(model);
            arn(model.arn);
            chatChannel(model.chatChannel);
            clientToken(model.clientToken);
            impact(model.impact);
            notificationTargets(model.notificationTargets);
            status(model.status);
            summary(model.summary);
            title(model.title);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ChatChannel.Builder getChatChannel() {
            return chatChannel != null ? chatChannel.toBuilder() : null;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        @Override
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getImpact() {
            return impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final List<NotificationTargetItem.Builder> getNotificationTargets() {
            List<NotificationTargetItem.Builder> result = NotificationTargetSetCopier.copyToBuilder(this.notificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationTargets(Collection<NotificationTargetItem.BuilderImpl> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copyFromBuilder(notificationTargets);
        }

        @Override
        public final Builder notificationTargets(Collection<NotificationTargetItem> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copy(notificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTargets(NotificationTargetItem... notificationTargets) {
            notificationTargets(Arrays.asList(notificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTargets(Consumer<NotificationTargetItem.Builder>... notificationTargets) {
            notificationTargets(Stream.of(notificationTargets)
                    .map(c -> NotificationTargetItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IncidentRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSummary() {
            return summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIncidentRecordRequest build() {
            return new UpdateIncidentRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
