/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReplicationSetResponse extends SsmIncidentsResponse implements
        ToCopyableBuilder<GetReplicationSetResponse.Builder, GetReplicationSetResponse> {
    private static final SdkField<ReplicationSet> REPLICATION_SET_FIELD = SdkField
            .<ReplicationSet> builder(MarshallingType.SDK_POJO).memberName("replicationSet")
            .getter(getter(GetReplicationSetResponse::replicationSet)).setter(setter(Builder::replicationSet))
            .constructor(ReplicationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_SET_FIELD));

    private final ReplicationSet replicationSet;

    private GetReplicationSetResponse(BuilderImpl builder) {
        super(builder);
        this.replicationSet = builder.replicationSet;
    }

    /**
     * <p>
     * Details of the replication set.
     * </p>
     * 
     * @return Details of the replication set.
     */
    public final ReplicationSet replicationSet() {
        return replicationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationSetResponse)) {
            return false;
        }
        GetReplicationSetResponse other = (GetReplicationSetResponse) obj;
        return Objects.equals(replicationSet(), other.replicationSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReplicationSetResponse").add("ReplicationSet", replicationSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationSet":
            return Optional.ofNullable(clazz.cast(replicationSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReplicationSetResponse, T> g) {
        return obj -> g.apply((GetReplicationSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReplicationSetResponse> {
        /**
         * <p>
         * Details of the replication set.
         * </p>
         * 
         * @param replicationSet
         *        Details of the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSet(ReplicationSet replicationSet);

        /**
         * <p>
         * Details of the replication set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationSet.Builder} avoiding the need
         * to create one manually via {@link ReplicationSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationSet(ReplicationSet)}.
         * 
         * @param replicationSet
         *        a consumer that will call methods on {@link ReplicationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationSet(ReplicationSet)
         */
        default Builder replicationSet(Consumer<ReplicationSet.Builder> replicationSet) {
            return replicationSet(ReplicationSet.builder().applyMutation(replicationSet).build());
        }
    }

    static final class BuilderImpl extends SsmIncidentsResponse.BuilderImpl implements Builder {
        private ReplicationSet replicationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationSetResponse model) {
            super(model);
            replicationSet(model.replicationSet);
        }

        public final ReplicationSet.Builder getReplicationSet() {
            return replicationSet != null ? replicationSet.toBuilder() : null;
        }

        public final void setReplicationSet(ReplicationSet.BuilderImpl replicationSet) {
            this.replicationSet = replicationSet != null ? replicationSet.build() : null;
        }

        @Override
        public final Builder replicationSet(ReplicationSet replicationSet) {
            this.replicationSet = replicationSet;
            return this;
        }

        @Override
        public GetReplicationSetResponse build() {
            return new GetReplicationSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
