/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An item referenced in a <code>TimelineEvent</code> that is involved in or somehow associated with an incident. You
 * can specify an Amazon Resource Name (ARN) for an Amazon Web Services resource or a <code>RelatedItem</code> ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventReference implements SdkPojo, Serializable, ToCopyableBuilder<EventReference.Builder, EventReference> {
    private static final SdkField<String> RELATED_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedItemId").getter(getter(EventReference::relatedItemId)).setter(setter(Builder::relatedItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemId").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(EventReference::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_ITEM_ID_FIELD,
            RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String relatedItemId;

    private final String resource;

    private final Type type;

    private EventReference(BuilderImpl builder) {
        this.relatedItemId = builder.relatedItemId;
        this.resource = builder.resource;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of a <code>RelatedItem</code> referenced in a <code>TimelineEvent</code>.
     * </p>
     * 
     * @return The ID of a <code>RelatedItem</code> referenced in a <code>TimelineEvent</code>.
     */
    public final String relatedItemId() {
        return relatedItemId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced in a <code>TimelineEvent</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced in a
     *         <code>TimelineEvent</code>.
     */
    public final String resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemId());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventReference)) {
            return false;
        }
        EventReference other = (EventReference) obj;
        return Objects.equals(relatedItemId(), other.relatedItemId()) && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventReference").add("RelatedItemId", relatedItemId()).add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relatedItemId":
            return Optional.ofNullable(clazz.cast(relatedItemId()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #relatedItemId()} initialized to the given value.
     *
     * <p>
     * The ID of a <code>RelatedItem</code> referenced in a <code>TimelineEvent</code>.
     * </p>
     * 
     * @param relatedItemId
     *        The ID of a <code>RelatedItem</code> referenced in a <code>TimelineEvent</code>.
     */
    public static EventReference fromRelatedItemId(String relatedItemId) {
        return builder().relatedItemId(relatedItemId).build();
    }

    /**
     * Create an instance of this class with {@link #resource()} initialized to the given value.
     *
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced in a <code>TimelineEvent</code>.
     * </p>
     * 
     * @param resource
     *        The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced in a
     *        <code>TimelineEvent</code>.
     */
    public static EventReference fromResource(String resource) {
        return builder().resource(resource).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventReference, T> g) {
        return obj -> g.apply((EventReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventReference> {
        /**
         * <p>
         * The ID of a <code>RelatedItem</code> referenced in a <code>TimelineEvent</code>.
         * </p>
         * 
         * @param relatedItemId
         *        The ID of a <code>RelatedItem</code> referenced in a <code>TimelineEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItemId(String relatedItemId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced in a <code>TimelineEvent</code>.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced in a
         *        <code>TimelineEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);
    }

    static final class BuilderImpl implements Builder {
        private String relatedItemId;

        private String resource;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventReference model) {
            relatedItemId(model.relatedItemId);
            resource(model.resource);
        }

        public final String getRelatedItemId() {
            return relatedItemId;
        }

        public final void setRelatedItemId(String relatedItemId) {
            Object oldValue = this.relatedItemId;
            this.relatedItemId = relatedItemId;
            handleUnionValueChange(Type.RELATED_ITEM_ID, oldValue, this.relatedItemId);
        }

        @Override
        public final Builder relatedItemId(String relatedItemId) {
            Object oldValue = this.relatedItemId;
            this.relatedItemId = relatedItemId;
            handleUnionValueChange(Type.RELATED_ITEM_ID, oldValue, this.relatedItemId);
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            Object oldValue = this.resource;
            this.resource = resource;
            handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
        }

        @Override
        public final Builder resource(String resource) {
            Object oldValue = this.resource;
            this.resource = resource;
            handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
            return this;
        }

        @Override
        public EventReference build() {
            return new EventReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EventReference#type()
     */
    public enum Type {
        RELATED_ITEM_ID,

        RESOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
