/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Chatbot chat channel used for collaboration during an incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatChannel implements SdkPojo, Serializable, ToCopyableBuilder<ChatChannel.Builder, ChatChannel> {
    private static final SdkField<List<String>> CHATBOT_SNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("chatbotSns")
            .getter(getter(ChatChannel::chatbotSns))
            .setter(setter(Builder::chatbotSns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotSns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EmptyChatChannel> EMPTY_FIELD = SdkField.<EmptyChatChannel> builder(MarshallingType.SDK_POJO)
            .memberName("empty").getter(getter(ChatChannel::empty)).setter(setter(Builder::empty))
            .constructor(EmptyChatChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("empty").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHATBOT_SNS_FIELD, EMPTY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> chatbotSns;

    private final EmptyChatChannel empty;

    private final Type type;

    private ChatChannel(BuilderImpl builder) {
        this.chatbotSns = builder.chatbotSns;
        this.empty = builder.empty;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChatbotSns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChatbotSns() {
        return chatbotSns != null && !(chatbotSns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can also make
     * updates to the incident through the chat channel by using the Amazon SNS topics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChatbotSns} method.
     * </p>
     * 
     * @return The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can
     *         also make updates to the incident through the chat channel by using the Amazon SNS topics.
     */
    public final List<String> chatbotSns() {
        return chatbotSns;
    }

    /**
     * <p>
     * Used to remove the chat channel from an incident record or response plan.
     * </p>
     * 
     * @return Used to remove the chat channel from an incident record or response plan.
     */
    public final EmptyChatChannel empty() {
        return empty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChatbotSns() ? chatbotSns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(empty());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatChannel)) {
            return false;
        }
        ChatChannel other = (ChatChannel) obj;
        return hasChatbotSns() == other.hasChatbotSns() && Objects.equals(chatbotSns(), other.chatbotSns())
                && Objects.equals(empty(), other.empty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatChannel").add("ChatbotSns", hasChatbotSns() ? chatbotSns() : null).add("Empty", empty())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chatbotSns":
            return Optional.ofNullable(clazz.cast(chatbotSns()));
        case "empty":
            return Optional.ofNullable(clazz.cast(empty()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #chatbotSns()} initialized to the given value.
     *
     * <p>
     * The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can also make
     * updates to the incident through the chat channel by using the Amazon SNS topics.
     * </p>
     * 
     * @param chatbotSns
     *        The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can
     *        also make updates to the incident through the chat channel by using the Amazon SNS topics.
     */
    public static ChatChannel fromChatbotSns(List<String> chatbotSns) {
        return builder().chatbotSns(chatbotSns).build();
    }

    /**
     * Create an instance of this class with {@link #empty()} initialized to the given value.
     *
     * <p>
     * Used to remove the chat channel from an incident record or response plan.
     * </p>
     * 
     * @param empty
     *        Used to remove the chat channel from an incident record or response plan.
     */
    public static ChatChannel fromEmpty(EmptyChatChannel empty) {
        return builder().empty(empty).build();
    }

    /**
     * Create an instance of this class with {@link #empty()} initialized to the given value.
     *
     * <p>
     * Used to remove the chat channel from an incident record or response plan.
     * </p>
     * 
     * @param empty
     *        Used to remove the chat channel from an incident record or response plan.
     */
    public static ChatChannel fromEmpty(Consumer<EmptyChatChannel.Builder> empty) {
        EmptyChatChannel.Builder builder = EmptyChatChannel.builder();
        empty.accept(builder);
        return fromEmpty(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChatChannel, T> g) {
        return obj -> g.apply((ChatChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatChannel> {
        /**
         * <p>
         * The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can also
         * make updates to the incident through the chat channel by using the Amazon SNS topics.
         * </p>
         * 
         * @param chatbotSns
         *        The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can
         *        also make updates to the incident through the chat channel by using the Amazon SNS topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatbotSns(Collection<String> chatbotSns);

        /**
         * <p>
         * The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can also
         * make updates to the incident through the chat channel by using the Amazon SNS topics.
         * </p>
         * 
         * @param chatbotSns
         *        The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can
         *        also make updates to the incident through the chat channel by using the Amazon SNS topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatbotSns(String... chatbotSns);

        /**
         * <p>
         * Used to remove the chat channel from an incident record or response plan.
         * </p>
         * 
         * @param empty
         *        Used to remove the chat channel from an incident record or response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder empty(EmptyChatChannel empty);

        /**
         * <p>
         * Used to remove the chat channel from an incident record or response plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmptyChatChannel.Builder} avoiding the
         * need to create one manually via {@link EmptyChatChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmptyChatChannel.Builder#build()} is called immediately and its
         * result is passed to {@link #empty(EmptyChatChannel)}.
         * 
         * @param empty
         *        a consumer that will call methods on {@link EmptyChatChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #empty(EmptyChatChannel)
         */
        default Builder empty(Consumer<EmptyChatChannel.Builder> empty) {
            return empty(EmptyChatChannel.builder().applyMutation(empty).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> chatbotSns = DefaultSdkAutoConstructList.getInstance();

        private EmptyChatChannel empty;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChatChannel model) {
            chatbotSns(model.chatbotSns);
            empty(model.empty);
        }

        public final Collection<String> getChatbotSns() {
            if (chatbotSns instanceof SdkAutoConstructList) {
                return null;
            }
            return chatbotSns;
        }

        public final void setChatbotSns(Collection<String> chatbotSns) {
            Object oldValue = this.chatbotSns;
            this.chatbotSns = ChatbotSnsConfigurationSetCopier.copy(chatbotSns);
            handleUnionValueChange(Type.CHATBOT_SNS, oldValue, this.chatbotSns);
        }

        @Override
        public final Builder chatbotSns(Collection<String> chatbotSns) {
            Object oldValue = this.chatbotSns;
            this.chatbotSns = ChatbotSnsConfigurationSetCopier.copy(chatbotSns);
            handleUnionValueChange(Type.CHATBOT_SNS, oldValue, this.chatbotSns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chatbotSns(String... chatbotSns) {
            chatbotSns(Arrays.asList(chatbotSns));
            return this;
        }

        public final EmptyChatChannel.Builder getEmpty() {
            return empty != null ? empty.toBuilder() : null;
        }

        public final void setEmpty(EmptyChatChannel.BuilderImpl empty) {
            Object oldValue = this.empty;
            this.empty = empty != null ? empty.build() : null;
            handleUnionValueChange(Type.EMPTY, oldValue, this.empty);
        }

        @Override
        public final Builder empty(EmptyChatChannel empty) {
            Object oldValue = this.empty;
            this.empty = empty;
            handleUnionValueChange(Type.EMPTY, oldValue, this.empty);
            return this;
        }

        @Override
        public ChatChannel build() {
            return new ChatChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ChatChannel#type()
     */
    public enum Type {
        CHATBOT_SNS,

        EMPTY,

        UNKNOWN_TO_SDK_VERSION
    }
}
