/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Page;

public class ListPagesByContactIterable
implements SdkIterable<ListPagesByContactResponse> {
    private final SsmContactsClient client;
    private final ListPagesByContactRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPagesByContactIterable(SsmContactsClient client, ListPagesByContactRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPagesByContactResponseFetcher();
    }

    public Iterator<ListPagesByContactResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Page> pages() {
        Function<ListPagesByContactResponse, Iterator> getIterator = response -> {
            if (response != null && response.pages() != null) {
                return response.pages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPagesByContactResponseFetcher
    implements SyncPageFetcher<ListPagesByContactResponse> {
        private ListPagesByContactResponseFetcher() {
        }

        public boolean hasNextPage(ListPagesByContactResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPagesByContactResponse nextPage(ListPagesByContactResponse previousPage) {
            if (previousPage == null) {
                return ListPagesByContactIterable.this.client.listPagesByContact(ListPagesByContactIterable.this.firstRequest);
            }
            return ListPagesByContactIterable.this.client.listPagesByContact((ListPagesByContactRequest)((Object)ListPagesByContactIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

