/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEngagementResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, DescribeEngagementResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::contactArn)).setter(DescribeEngagementResponse.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementArn").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::engagementArn)).setter(DescribeEngagementResponse.setter(Builder::engagementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()}).build();
    private static final SdkField<String> SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sender").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::sender)).setter(DescribeEngagementResponse.setter(Builder::sender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::subject)).setter(DescribeEngagementResponse.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::content)).setter(DescribeEngagementResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> PUBLIC_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicSubject").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::publicSubject)).setter(DescribeEngagementResponse.setter(Builder::publicSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSubject").build()}).build();
    private static final SdkField<String> PUBLIC_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicContent").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::publicContent)).setter(DescribeEngagementResponse.setter(Builder::publicContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicContent").build()}).build();
    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncidentId").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::incidentId)).setter(DescribeEngagementResponse.setter(Builder::incidentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::startTime)).setter(DescribeEngagementResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StopTime").getter(DescribeEngagementResponse.getter(DescribeEngagementResponse::stopTime)).setter(DescribeEngagementResponse.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, ENGAGEMENT_ARN_FIELD, SENDER_FIELD, SUBJECT_FIELD, CONTENT_FIELD, PUBLIC_SUBJECT_FIELD, PUBLIC_CONTENT_FIELD, INCIDENT_ID_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));
    private final String contactArn;
    private final String engagementArn;
    private final String sender;
    private final String subject;
    private final String content;
    private final String publicSubject;
    private final String publicContent;
    private final String incidentId;
    private final Instant startTime;
    private final Instant stopTime;

    private DescribeEngagementResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.engagementArn = builder.engagementArn;
        this.sender = builder.sender;
        this.subject = builder.subject;
        this.content = builder.content;
        this.publicSubject = builder.publicSubject;
        this.publicContent = builder.publicContent;
        this.incidentId = builder.incidentId;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String engagementArn() {
        return this.engagementArn;
    }

    public final String sender() {
        return this.sender;
    }

    public final String subject() {
        return this.subject;
    }

    public final String content() {
        return this.content;
    }

    public final String publicSubject() {
        return this.publicSubject;
    }

    public final String publicContent() {
        return this.publicContent;
    }

    public final String incidentId() {
        return this.incidentId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngagementResponse)) {
            return false;
        }
        DescribeEngagementResponse other = (DescribeEngagementResponse)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.engagementArn(), other.engagementArn()) && Objects.equals(this.sender(), other.sender()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.publicSubject(), other.publicSubject()) && Objects.equals(this.publicContent(), other.publicContent()) && Objects.equals(this.incidentId(), other.incidentId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEngagementResponse").add("ContactArn", (Object)this.contactArn()).add("EngagementArn", (Object)this.engagementArn()).add("Sender", (Object)this.sender()).add("Subject", (Object)this.subject()).add("Content", (Object)this.content()).add("PublicSubject", (Object)this.publicSubject()).add("PublicContent", (Object)this.publicContent()).add("IncidentId", (Object)this.incidentId()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "EngagementArn": {
                return Optional.ofNullable(clazz.cast(this.engagementArn()));
            }
            case "Sender": {
                return Optional.ofNullable(clazz.cast(this.sender()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "PublicSubject": {
                return Optional.ofNullable(clazz.cast(this.publicSubject()));
            }
            case "PublicContent": {
                return Optional.ofNullable(clazz.cast(this.publicContent()));
            }
            case "IncidentId": {
                return Optional.ofNullable(clazz.cast(this.incidentId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "StopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngagementResponse, T> g) {
        return obj -> g.apply((DescribeEngagementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String contactArn;
        private String engagementArn;
        private String sender;
        private String subject;
        private String content;
        private String publicSubject;
        private String publicContent;
        private String incidentId;
        private Instant startTime;
        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngagementResponse model) {
            super(model);
            this.contactArn(model.contactArn);
            this.engagementArn(model.engagementArn);
            this.sender(model.sender);
            this.subject(model.subject);
            this.content(model.content);
            this.publicSubject(model.publicSubject);
            this.publicContent(model.publicContent);
            this.incidentId(model.incidentId);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getEngagementArn() {
            return this.engagementArn;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final String getSender() {
            return this.sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getPublicSubject() {
            return this.publicSubject;
        }

        public final void setPublicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
        }

        @Override
        public final Builder publicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
            return this;
        }

        public final String getPublicContent() {
            return this.publicContent;
        }

        public final void setPublicContent(String publicContent) {
            this.publicContent = publicContent;
        }

        @Override
        public final Builder publicContent(String publicContent) {
            this.publicContent = publicContent;
            return this;
        }

        public final String getIncidentId() {
            return this.incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        @Override
        public DescribeEngagementResponse build() {
            return new DescribeEngagementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEngagementResponse> {
        public Builder contactArn(String var1);

        public Builder engagementArn(String var1);

        public Builder sender(String var1);

        public Builder subject(String var1);

        public Builder content(String var1);

        public Builder publicSubject(String var1);

        public Builder publicContent(String var1);

        public Builder incidentId(String var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);
    }
}

