/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Incident Manager engaging a contact's contact channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Page implements SdkPojo, Serializable, ToCopyableBuilder<Page.Builder, Page> {
    private static final SdkField<String> PAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageArn").getter(getter(Page::pageArn)).setter(setter(Builder::pageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageArn").build()).build();

    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementArn").getter(getter(Page::engagementArn)).setter(setter(Builder::engagementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(Page::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> SENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sender")
            .getter(getter(Page::sender)).setter(setter(Builder::sender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncidentId").getter(getter(Page::incidentId)).setter(setter(Builder::incidentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()).build();

    private static final SdkField<Instant> SENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SentTime").getter(getter(Page::sentTime)).setter(setter(Builder::sentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentTime").build()).build();

    private static final SdkField<Instant> DELIVERY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeliveryTime").getter(getter(Page::deliveryTime)).setter(setter(Builder::deliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTime").build()).build();

    private static final SdkField<Instant> READ_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReadTime").getter(getter(Page::readTime)).setter(setter(Builder::readTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_ARN_FIELD,
            ENGAGEMENT_ARN_FIELD, CONTACT_ARN_FIELD, SENDER_FIELD, INCIDENT_ID_FIELD, SENT_TIME_FIELD, DELIVERY_TIME_FIELD,
            READ_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pageArn;

    private final String engagementArn;

    private final String contactArn;

    private final String sender;

    private final String incidentId;

    private final Instant sentTime;

    private final Instant deliveryTime;

    private final Instant readTime;

    private Page(BuilderImpl builder) {
        this.pageArn = builder.pageArn;
        this.engagementArn = builder.engagementArn;
        this.contactArn = builder.contactArn;
        this.sender = builder.sender;
        this.incidentId = builder.incidentId;
        this.sentTime = builder.sentTime;
        this.deliveryTime = builder.deliveryTime;
        this.readTime = builder.readTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the page to the contact channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the page to the contact channel.
     */
    public final String pageArn() {
        return pageArn;
    }

    /**
     * <p>
     * The ARN of the engagement that this page is part of.
     * </p>
     * 
     * @return The ARN of the engagement that this page is part of.
     */
    public final String engagementArn() {
        return engagementArn;
    }

    /**
     * <p>
     * The ARN of the contact that Incident Manager is engaging.
     * </p>
     * 
     * @return The ARN of the contact that Incident Manager is engaging.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The user that started the engagement.
     * </p>
     * 
     * @return The user that started the engagement.
     */
    public final String sender() {
        return sender;
    }

    /**
     * <p>
     * The ARN of the incident that's engaging the contact channel.
     * </p>
     * 
     * @return The ARN of the incident that's engaging the contact channel.
     */
    public final String incidentId() {
        return incidentId;
    }

    /**
     * <p>
     * The time that Incident Manager engaged the contact channel.
     * </p>
     * 
     * @return The time that Incident Manager engaged the contact channel.
     */
    public final Instant sentTime() {
        return sentTime;
    }

    /**
     * <p>
     * The time the message was delivered to the contact channel.
     * </p>
     * 
     * @return The time the message was delivered to the contact channel.
     */
    public final Instant deliveryTime() {
        return deliveryTime;
    }

    /**
     * <p>
     * The time that the contact channel acknowledged engagement.
     * </p>
     * 
     * @return The time that the contact channel acknowledged engagement.
     */
    public final Instant readTime() {
        return readTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pageArn());
        hashCode = 31 * hashCode + Objects.hashCode(engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        hashCode = 31 * hashCode + Objects.hashCode(incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(sentTime());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(readTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page) obj;
        return Objects.equals(pageArn(), other.pageArn()) && Objects.equals(engagementArn(), other.engagementArn())
                && Objects.equals(contactArn(), other.contactArn()) && Objects.equals(sender(), other.sender())
                && Objects.equals(incidentId(), other.incidentId()) && Objects.equals(sentTime(), other.sentTime())
                && Objects.equals(deliveryTime(), other.deliveryTime()) && Objects.equals(readTime(), other.readTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Page").add("PageArn", pageArn()).add("EngagementArn", engagementArn())
                .add("ContactArn", contactArn()).add("Sender", sender()).add("IncidentId", incidentId())
                .add("SentTime", sentTime()).add("DeliveryTime", deliveryTime()).add("ReadTime", readTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageArn":
            return Optional.ofNullable(clazz.cast(pageArn()));
        case "EngagementArn":
            return Optional.ofNullable(clazz.cast(engagementArn()));
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        case "IncidentId":
            return Optional.ofNullable(clazz.cast(incidentId()));
        case "SentTime":
            return Optional.ofNullable(clazz.cast(sentTime()));
        case "DeliveryTime":
            return Optional.ofNullable(clazz.cast(deliveryTime()));
        case "ReadTime":
            return Optional.ofNullable(clazz.cast(readTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Page> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the page to the contact channel.
         * </p>
         * 
         * @param pageArn
         *        The Amazon Resource Name (ARN) of the page to the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageArn(String pageArn);

        /**
         * <p>
         * The ARN of the engagement that this page is part of.
         * </p>
         * 
         * @param engagementArn
         *        The ARN of the engagement that this page is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementArn(String engagementArn);

        /**
         * <p>
         * The ARN of the contact that Incident Manager is engaging.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the contact that Incident Manager is engaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The user that started the engagement.
         * </p>
         * 
         * @param sender
         *        The user that started the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);

        /**
         * <p>
         * The ARN of the incident that's engaging the contact channel.
         * </p>
         * 
         * @param incidentId
         *        The ARN of the incident that's engaging the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentId(String incidentId);

        /**
         * <p>
         * The time that Incident Manager engaged the contact channel.
         * </p>
         * 
         * @param sentTime
         *        The time that Incident Manager engaged the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentTime(Instant sentTime);

        /**
         * <p>
         * The time the message was delivered to the contact channel.
         * </p>
         * 
         * @param deliveryTime
         *        The time the message was delivered to the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryTime(Instant deliveryTime);

        /**
         * <p>
         * The time that the contact channel acknowledged engagement.
         * </p>
         * 
         * @param readTime
         *        The time that the contact channel acknowledged engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readTime(Instant readTime);
    }

    static final class BuilderImpl implements Builder {
        private String pageArn;

        private String engagementArn;

        private String contactArn;

        private String sender;

        private String incidentId;

        private Instant sentTime;

        private Instant deliveryTime;

        private Instant readTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            pageArn(model.pageArn);
            engagementArn(model.engagementArn);
            contactArn(model.contactArn);
            sender(model.sender);
            incidentId(model.incidentId);
            sentTime(model.sentTime);
            deliveryTime(model.deliveryTime);
            readTime(model.readTime);
        }

        public final String getPageArn() {
            return pageArn;
        }

        public final void setPageArn(String pageArn) {
            this.pageArn = pageArn;
        }

        @Override
        public final Builder pageArn(String pageArn) {
            this.pageArn = pageArn;
            return this;
        }

        public final String getEngagementArn() {
            return engagementArn;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getSender() {
            return sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getIncidentId() {
            return incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final Instant getSentTime() {
            return sentTime;
        }

        public final void setSentTime(Instant sentTime) {
            this.sentTime = sentTime;
        }

        @Override
        public final Builder sentTime(Instant sentTime) {
            this.sentTime = sentTime;
            return this;
        }

        public final Instant getDeliveryTime() {
            return deliveryTime;
        }

        public final void setDeliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        @Override
        public final Builder deliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public final Instant getReadTime() {
            return readTime;
        }

        public final void setReadTime(Instant readTime) {
            this.readTime = readTime;
        }

        @Override
        public final Builder readTime(Instant readTime) {
            this.readTime = readTime;
            return this;
        }

        @Override
        public Page build() {
            return new Page(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
