/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.auth.scheme.SsmAuthSchemeProvider;
import software.amazon.awssdk.services.ssm.internal.SsmServiceClientConfigurationBuilder;

/**
 * Class to expose the service client settings to the user. Implementation of {@link AwsServiceClientConfiguration}
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class SsmServiceClientConfiguration extends AwsServiceClientConfiguration {
    private final SsmAuthSchemeProvider authSchemeProvider;

    public SsmServiceClientConfiguration(Builder builder) {
        super(builder);
        this.authSchemeProvider = builder.authSchemeProvider();
    }

    /**
     * Gets the value for auth scheme provider
     */
    public SsmAuthSchemeProvider authSchemeProvider() {
        return authSchemeProvider;
    }

    public static Builder builder() {
        return SsmServiceClientConfigurationBuilder.builder();
    }

    /**
     * A builder for creating a {@link SsmServiceClientConfiguration}
     */
    public interface Builder extends AwsServiceClientConfiguration.Builder {
        /**
         * Sets the value for client override configuration
         */
        @Override
        Builder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration);

        /**
         * Gets the value for client override configuration
         */
        @Override
        ClientOverrideConfiguration overrideConfiguration();

        /**
         * Sets the value for endpoint override
         */
        @Override
        Builder endpointOverride(URI endpointOverride);

        /**
         * Gets the value for endpoint override
         */
        @Override
        URI endpointOverride();

        /**
         * Sets the value for endpoint provider
         */
        @Override
        Builder endpointProvider(EndpointProvider endpointProvider);

        /**
         * Gets the value for endpoint provider
         */
        @Override
        EndpointProvider endpointProvider();

        /**
         * Sets the value for AWS region
         */
        @Override
        Builder region(Region region);

        /**
         * Gets the value for AWS region
         */
        @Override
        Region region();

        /**
         * Sets the value for credentials provider
         */
        @Override
        Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider);

        /**
         * Gets the value for credentials provider
         */
        @Override
        IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider();

        @Override
        Builder putAuthScheme(AuthScheme<?> authScheme);

        /**
         * Gets the value for auth schemes
         */
        @Override
        Map<String, AuthScheme<?>> authSchemes();

        /**
         * Sets the value for auth scheme provider
         */
        Builder authSchemeProvider(SsmAuthSchemeProvider authSchemeProvider);

        /**
         * Gets the value for auth scheme provider
         */
        SsmAuthSchemeProvider authSchemeProvider();

        @Override
        SsmServiceClientConfiguration build();
    }
}
