/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.AssociationVersionInfo;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;

public class ListAssociationVersionsPublisher
implements SdkPublisher<ListAssociationVersionsResponse> {
    private final SsmAsyncClient client;
    private final ListAssociationVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociationVersionsPublisher(SsmAsyncClient client, ListAssociationVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociationVersionsPublisher(SsmAsyncClient client, ListAssociationVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociationVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociationVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociationVersionInfo> associationVersions() {
        Function<ListAssociationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associationVersions() != null) {
                return response.associationVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssociationVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssociationVersionsResponseFetcher
    implements AsyncPageFetcher<ListAssociationVersionsResponse> {
        private ListAssociationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociationVersionsResponse> nextPage(ListAssociationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationVersionsPublisher.this.client.listAssociationVersions(ListAssociationVersionsPublisher.this.firstRequest);
            }
            return ListAssociationVersionsPublisher.this.client.listAssociationVersions((ListAssociationVersionsRequest)((Object)ListAssociationVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

