/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAutomationExecutionResponse extends SsmResponse implements
        ToCopyableBuilder<StartAutomationExecutionResponse.Builder, StartAutomationExecutionResponse> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomationExecutionId").getter(getter(StartAutomationExecutionResponse::automationExecutionId))
            .setter(setter(Builder::automationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD));

    private final String automationExecutionId;

    private StartAutomationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecutionId = builder.automationExecutionId;
    }

    /**
     * <p>
     * The unique ID of a newly scheduled automation execution.
     * </p>
     * 
     * @return The unique ID of a newly scheduled automation execution.
     */
    public final String automationExecutionId() {
        return automationExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationExecutionResponse)) {
            return false;
        }
        StartAutomationExecutionResponse other = (StartAutomationExecutionResponse) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAutomationExecutionResponse").add("AutomationExecutionId", automationExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.ofNullable(clazz.cast(automationExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAutomationExecutionResponse, T> g) {
        return obj -> g.apply((StartAutomationExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartAutomationExecutionResponse> {
        /**
         * <p>
         * The unique ID of a newly scheduled automation execution.
         * </p>
         * 
         * @param automationExecutionId
         *        The unique ID of a newly scheduled automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String automationExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomationExecutionResponse model) {
            super(model);
            automationExecutionId(model.automationExecutionId);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        @Override
        public StartAutomationExecutionResponse build() {
            return new StartAutomationExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
