/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for a <code>LAMBDA</code> task type.
 * </p>
 * <p>
 * For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and
 * <a>UpdateMaintenanceWindowTask</a>.
 * </p>
 * <note>
 * <p>
 * <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to
 * contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
 * <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager
 * handles these options for the supported maintenance window task types, see
 * <a>MaintenanceWindowTaskInvocationParameters</a>.
 * </p>
 * <p>
 * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use
 * the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how
 * Systems Manager handles these options for the supported maintenance window task types, see
 * <a>MaintenanceWindowTaskInvocationParameters</a>.
 * </p>
 * <p>
 * For Lambda tasks, Systems Manager ignores any values specified for TaskParameters and LoggingInfo.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowLambdaParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindowLambdaParameters.Builder, MaintenanceWindowLambdaParameters> {
    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientContext").getter(getter(MaintenanceWindowLambdaParameters::clientContext))
            .setter(setter(Builder::clientContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientContext").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(MaintenanceWindowLambdaParameters::qualifier))
            .setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qualifier").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Payload").getter(getter(MaintenanceWindowLambdaParameters::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONTEXT_FIELD,
            QUALIFIER_FIELD, PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientContext;

    private final String qualifier;

    private final SdkBytes payload;

    private MaintenanceWindowLambdaParameters(BuilderImpl builder) {
        this.clientContext = builder.clientContext;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * Pass client-specific information to the Lambda function that you are invoking. You can then process the client
     * information in your Lambda function as you choose through the context variable.
     * </p>
     * 
     * @return Pass client-specific information to the Lambda function that you are invoking. You can then process the
     *         client information in your Lambda function as you choose through the context variable.
     */
    public final String clientContext() {
        return clientContext;
    }

    /**
     * <p>
     * (Optional) Specify an Lambda function version or alias name. If you specify a function version, the operation
     * uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify an
     * alias name, the operation uses the alias ARN to invoke the Lambda function version to which the alias points.
     * </p>
     * 
     * @return (Optional) Specify an Lambda function version or alias name. If you specify a function version, the
     *         operation uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If
     *         you specify an alias name, the operation uses the alias ARN to invoke the Lambda function version to
     *         which the alias points.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * JSON to provide to your Lambda function as input.
     * </p>
     * 
     * @return JSON to provide to your Lambda function as input.
     */
    public final SdkBytes payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowLambdaParameters)) {
            return false;
        }
        MaintenanceWindowLambdaParameters other = (MaintenanceWindowLambdaParameters) obj;
        return Objects.equals(clientContext(), other.clientContext()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceWindowLambdaParameters").add("ClientContext", clientContext())
                .add("Qualifier", qualifier()).add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientContext":
            return Optional.ofNullable(clazz.cast(clientContext()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowLambdaParameters, T> g) {
        return obj -> g.apply((MaintenanceWindowLambdaParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
        /**
         * <p>
         * Pass client-specific information to the Lambda function that you are invoking. You can then process the
         * client information in your Lambda function as you choose through the context variable.
         * </p>
         * 
         * @param clientContext
         *        Pass client-specific information to the Lambda function that you are invoking. You can then process
         *        the client information in your Lambda function as you choose through the context variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientContext(String clientContext);

        /**
         * <p>
         * (Optional) Specify an Lambda function version or alias name. If you specify a function version, the operation
         * uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify
         * an alias name, the operation uses the alias ARN to invoke the Lambda function version to which the alias
         * points.
         * </p>
         * 
         * @param qualifier
         *        (Optional) Specify an Lambda function version or alias name. If you specify a function version, the
         *        operation uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function.
         *        If you specify an alias name, the operation uses the alias ARN to invoke the Lambda function version
         *        to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * JSON to provide to your Lambda function as input.
         * </p>
         * 
         * @param payload
         *        JSON to provide to your Lambda function as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);
    }

    static final class BuilderImpl implements Builder {
        private String clientContext;

        private String qualifier;

        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowLambdaParameters model) {
            clientContext(model.clientContext);
            qualifier(model.qualifier);
            payload(model.payload);
        }

        public final String getClientContext() {
            return clientContext;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public MaintenanceWindowLambdaParameters build() {
            return new MaintenanceWindowLambdaParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
