/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SessionFilterKey {
    INVOKED_AFTER("InvokedAfter"),
    INVOKED_BEFORE("InvokedBefore"),
    TARGET("Target"),
    OWNER("Owner"),
    STATUS("Status"),
    SESSION_ID("SessionId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SessionFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SessionFilterKey.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionFilterKey> knownValues() {
        return Stream.of(SessionFilterKey.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

