/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgressCounters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgressCounters> {
    private static final SdkField<Integer> TOTAL_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalSteps").getter(ProgressCounters.getter(ProgressCounters::totalSteps)).setter(ProgressCounters.setter(Builder::totalSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSteps").build()}).build();
    private static final SdkField<Integer> SUCCESS_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessSteps").getter(ProgressCounters.getter(ProgressCounters::successSteps)).setter(ProgressCounters.setter(Builder::successSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessSteps").build()}).build();
    private static final SdkField<Integer> FAILED_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedSteps").getter(ProgressCounters.getter(ProgressCounters::failedSteps)).setter(ProgressCounters.setter(Builder::failedSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedSteps").build()}).build();
    private static final SdkField<Integer> CANCELLED_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CancelledSteps").getter(ProgressCounters.getter(ProgressCounters::cancelledSteps)).setter(ProgressCounters.setter(Builder::cancelledSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledSteps").build()}).build();
    private static final SdkField<Integer> TIMED_OUT_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimedOutSteps").getter(ProgressCounters.getter(ProgressCounters::timedOutSteps)).setter(ProgressCounters.setter(Builder::timedOutSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimedOutSteps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_STEPS_FIELD, SUCCESS_STEPS_FIELD, FAILED_STEPS_FIELD, CANCELLED_STEPS_FIELD, TIMED_OUT_STEPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalSteps;
    private final Integer successSteps;
    private final Integer failedSteps;
    private final Integer cancelledSteps;
    private final Integer timedOutSteps;

    private ProgressCounters(BuilderImpl builder) {
        this.totalSteps = builder.totalSteps;
        this.successSteps = builder.successSteps;
        this.failedSteps = builder.failedSteps;
        this.cancelledSteps = builder.cancelledSteps;
        this.timedOutSteps = builder.timedOutSteps;
    }

    public final Integer totalSteps() {
        return this.totalSteps;
    }

    public final Integer successSteps() {
        return this.successSteps;
    }

    public final Integer failedSteps() {
        return this.failedSteps;
    }

    public final Integer cancelledSteps() {
        return this.cancelledSteps;
    }

    public final Integer timedOutSteps() {
        return this.timedOutSteps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.successSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelledSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedOutSteps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressCounters)) {
            return false;
        }
        ProgressCounters other = (ProgressCounters)obj;
        return Objects.equals(this.totalSteps(), other.totalSteps()) && Objects.equals(this.successSteps(), other.successSteps()) && Objects.equals(this.failedSteps(), other.failedSteps()) && Objects.equals(this.cancelledSteps(), other.cancelledSteps()) && Objects.equals(this.timedOutSteps(), other.timedOutSteps());
    }

    public final String toString() {
        return ToString.builder((String)"ProgressCounters").add("TotalSteps", (Object)this.totalSteps()).add("SuccessSteps", (Object)this.successSteps()).add("FailedSteps", (Object)this.failedSteps()).add("CancelledSteps", (Object)this.cancelledSteps()).add("TimedOutSteps", (Object)this.timedOutSteps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalSteps": {
                return Optional.ofNullable(clazz.cast(this.totalSteps()));
            }
            case "SuccessSteps": {
                return Optional.ofNullable(clazz.cast(this.successSteps()));
            }
            case "FailedSteps": {
                return Optional.ofNullable(clazz.cast(this.failedSteps()));
            }
            case "CancelledSteps": {
                return Optional.ofNullable(clazz.cast(this.cancelledSteps()));
            }
            case "TimedOutSteps": {
                return Optional.ofNullable(clazz.cast(this.timedOutSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProgressCounters, T> g) {
        return obj -> g.apply((ProgressCounters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalSteps;
        private Integer successSteps;
        private Integer failedSteps;
        private Integer cancelledSteps;
        private Integer timedOutSteps;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressCounters model) {
            this.totalSteps(model.totalSteps);
            this.successSteps(model.successSteps);
            this.failedSteps(model.failedSteps);
            this.cancelledSteps(model.cancelledSteps);
            this.timedOutSteps(model.timedOutSteps);
        }

        public final Integer getTotalSteps() {
            return this.totalSteps;
        }

        @Override
        public final Builder totalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        public final void setTotalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
        }

        public final Integer getSuccessSteps() {
            return this.successSteps;
        }

        @Override
        public final Builder successSteps(Integer successSteps) {
            this.successSteps = successSteps;
            return this;
        }

        public final void setSuccessSteps(Integer successSteps) {
            this.successSteps = successSteps;
        }

        public final Integer getFailedSteps() {
            return this.failedSteps;
        }

        @Override
        public final Builder failedSteps(Integer failedSteps) {
            this.failedSteps = failedSteps;
            return this;
        }

        public final void setFailedSteps(Integer failedSteps) {
            this.failedSteps = failedSteps;
        }

        public final Integer getCancelledSteps() {
            return this.cancelledSteps;
        }

        @Override
        public final Builder cancelledSteps(Integer cancelledSteps) {
            this.cancelledSteps = cancelledSteps;
            return this;
        }

        public final void setCancelledSteps(Integer cancelledSteps) {
            this.cancelledSteps = cancelledSteps;
        }

        public final Integer getTimedOutSteps() {
            return this.timedOutSteps;
        }

        @Override
        public final Builder timedOutSteps(Integer timedOutSteps) {
            this.timedOutSteps = timedOutSteps;
            return this;
        }

        public final void setTimedOutSteps(Integer timedOutSteps) {
            this.timedOutSteps = timedOutSteps;
        }

        public ProgressCounters build() {
            return new ProgressCounters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgressCounters> {
        public Builder totalSteps(Integer var1);

        public Builder successSteps(Integer var1);

        public Builder failedSteps(Integer var1);

        public Builder cancelledSteps(Integer var1);

        public Builder timedOutSteps(Integer var1);
    }
}

