/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DocumentHashType {
    SHA256("Sha256"),
    SHA1("Sha1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DocumentHashType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentHashType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DocumentHashType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentHashType> knownValues() {
        return Stream.of(DocumentHashType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

