/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMessageMoveTaskRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, StartMessageMoveTaskRequest> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(StartMessageMoveTaskRequest.getter(StartMessageMoveTaskRequest::sourceArn)).setter(StartMessageMoveTaskRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(StartMessageMoveTaskRequest.getter(StartMessageMoveTaskRequest::destinationArn)).setter(StartMessageMoveTaskRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()}).build();
    private static final SdkField<Integer> MAX_NUMBER_OF_MESSAGES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxNumberOfMessagesPerSecond").getter(StartMessageMoveTaskRequest.getter(StartMessageMoveTaskRequest::maxNumberOfMessagesPerSecond)).setter(StartMessageMoveTaskRequest.setter(Builder::maxNumberOfMessagesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfMessagesPerSecond").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, DESTINATION_ARN_FIELD, MAX_NUMBER_OF_MESSAGES_PER_SECOND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMessageMoveTaskRequest.memberNameToFieldInitializer();
    private final String sourceArn;
    private final String destinationArn;
    private final Integer maxNumberOfMessagesPerSecond;

    private StartMessageMoveTaskRequest(BuilderImpl builder) {
        super(builder);
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
        this.maxNumberOfMessagesPerSecond = builder.maxNumberOfMessagesPerSecond;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final Integer maxNumberOfMessagesPerSecond() {
        return this.maxNumberOfMessagesPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfMessagesPerSecond());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMessageMoveTaskRequest)) {
            return false;
        }
        StartMessageMoveTaskRequest other = (StartMessageMoveTaskRequest)((Object)obj);
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.maxNumberOfMessagesPerSecond(), other.maxNumberOfMessagesPerSecond());
    }

    public final String toString() {
        return ToString.builder((String)"StartMessageMoveTaskRequest").add("SourceArn", (Object)this.sourceArn()).add("DestinationArn", (Object)this.destinationArn()).add("MaxNumberOfMessagesPerSecond", (Object)this.maxNumberOfMessagesPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "MaxNumberOfMessagesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfMessagesPerSecond()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("DestinationArn", DESTINATION_ARN_FIELD);
        map.put("MaxNumberOfMessagesPerSecond", MAX_NUMBER_OF_MESSAGES_PER_SECOND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMessageMoveTaskRequest, T> g) {
        return obj -> g.apply((StartMessageMoveTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String sourceArn;
        private String destinationArn;
        private Integer maxNumberOfMessagesPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMessageMoveTaskRequest model) {
            super(model);
            this.sourceArn(model.sourceArn);
            this.destinationArn(model.destinationArn);
            this.maxNumberOfMessagesPerSecond(model.maxNumberOfMessagesPerSecond);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final Integer getMaxNumberOfMessagesPerSecond() {
            return this.maxNumberOfMessagesPerSecond;
        }

        public final void setMaxNumberOfMessagesPerSecond(Integer maxNumberOfMessagesPerSecond) {
            this.maxNumberOfMessagesPerSecond = maxNumberOfMessagesPerSecond;
        }

        @Override
        public final Builder maxNumberOfMessagesPerSecond(Integer maxNumberOfMessagesPerSecond) {
            this.maxNumberOfMessagesPerSecond = maxNumberOfMessagesPerSecond;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMessageMoveTaskRequest build() {
            return new StartMessageMoveTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMessageMoveTaskRequest> {
        public Builder sourceArn(String var1);

        public Builder destinationArn(String var1);

        public Builder maxNumberOfMessagesPerSecond(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

