/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTaskResponse extends SnowDeviceManagementResponse implements
        ToCopyableBuilder<CreateTaskResponse.Builder, CreateTaskResponse> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(CreateTaskResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(CreateTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TASK_ARN_FIELD, TASK_ID_FIELD));

    private final String taskArn;

    private final String taskId;

    private CreateTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task that you created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task that you created.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The ID of the task that you created.
     * </p>
     * 
     * @return The ID of the task that you created.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskResponse)) {
            return false;
        }
        CreateTaskResponse other = (CreateTaskResponse) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTaskResponse").add("TaskArn", taskArn()).add("TaskId", taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTaskResponse, T> g) {
        return obj -> g.apply((CreateTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowDeviceManagementResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTaskResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task that you created.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The ID of the task that you created.
         * </p>
         * 
         * @param taskId
         *        The ID of the task that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl extends SnowDeviceManagementResponse.BuilderImpl implements Builder {
        private String taskArn;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTaskResponse model) {
            super(model);
            taskArn(model.taskArn);
            taskId(model.taskId);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public CreateTaskResponse build() {
            return new CreateTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
