/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StorageUnit {
    TB("TB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StorageUnit> VALUE_MAP;
    private final String value;

    private StorageUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StorageUnit> knownValues() {
        EnumSet<StorageUnit> knownValues = EnumSet.allOf(StorageUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StorageUnit.class, StorageUnit::toString);
    }
}

