/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.CertificateHashesCopier;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRevocationStatusRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, GetRevocationStatusRequest> {
    private static final SdkField<Instant> SIGNATURE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("signatureTimestamp").getter(GetRevocationStatusRequest.getter(GetRevocationStatusRequest::signatureTimestamp)).setter(GetRevocationStatusRequest.setter(Builder::signatureTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("signatureTimestamp").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(GetRevocationStatusRequest.getter(GetRevocationStatusRequest::platformId)).setter(GetRevocationStatusRequest.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platformId").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersionArn").getter(GetRevocationStatusRequest.getter(GetRevocationStatusRequest::profileVersionArn)).setter(GetRevocationStatusRequest.setter(Builder::profileVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("profileVersionArn").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetRevocationStatusRequest.getter(GetRevocationStatusRequest::jobArn)).setter(GetRevocationStatusRequest.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("jobArn").build()}).build();
    private static final SdkField<List<String>> CERTIFICATE_HASHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateHashes").getter(GetRevocationStatusRequest.getter(GetRevocationStatusRequest::certificateHashes)).setter(GetRevocationStatusRequest.setter(Builder::certificateHashes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("certificateHashes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_TIMESTAMP_FIELD, PLATFORM_ID_FIELD, PROFILE_VERSION_ARN_FIELD, JOB_ARN_FIELD, CERTIFICATE_HASHES_FIELD));
    private final Instant signatureTimestamp;
    private final String platformId;
    private final String profileVersionArn;
    private final String jobArn;
    private final List<String> certificateHashes;

    private GetRevocationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.signatureTimestamp = builder.signatureTimestamp;
        this.platformId = builder.platformId;
        this.profileVersionArn = builder.profileVersionArn;
        this.jobArn = builder.jobArn;
        this.certificateHashes = builder.certificateHashes;
    }

    public final Instant signatureTimestamp() {
        return this.signatureTimestamp;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String profileVersionArn() {
        return this.profileVersionArn;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final boolean hasCertificateHashes() {
        return this.certificateHashes != null && !(this.certificateHashes instanceof SdkAutoConstructList);
    }

    public final List<String> certificateHashes() {
        return this.certificateHashes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateHashes() ? this.certificateHashes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevocationStatusRequest)) {
            return false;
        }
        GetRevocationStatusRequest other = (GetRevocationStatusRequest)((Object)obj);
        return Objects.equals(this.signatureTimestamp(), other.signatureTimestamp()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.profileVersionArn(), other.profileVersionArn()) && Objects.equals(this.jobArn(), other.jobArn()) && this.hasCertificateHashes() == other.hasCertificateHashes() && Objects.equals(this.certificateHashes(), other.certificateHashes());
    }

    public final String toString() {
        return ToString.builder((String)"GetRevocationStatusRequest").add("SignatureTimestamp", (Object)this.signatureTimestamp()).add("PlatformId", (Object)this.platformId()).add("ProfileVersionArn", (Object)this.profileVersionArn()).add("JobArn", (Object)this.jobArn()).add("CertificateHashes", this.hasCertificateHashes() ? this.certificateHashes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signatureTimestamp": {
                return Optional.ofNullable(clazz.cast(this.signatureTimestamp()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "profileVersionArn": {
                return Optional.ofNullable(clazz.cast(this.profileVersionArn()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "certificateHashes": {
                return Optional.ofNullable(clazz.cast(this.certificateHashes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRevocationStatusRequest, T> g) {
        return obj -> g.apply((GetRevocationStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private Instant signatureTimestamp;
        private String platformId;
        private String profileVersionArn;
        private String jobArn;
        private List<String> certificateHashes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRevocationStatusRequest model) {
            super(model);
            this.signatureTimestamp(model.signatureTimestamp);
            this.platformId(model.platformId);
            this.profileVersionArn(model.profileVersionArn);
            this.jobArn(model.jobArn);
            this.certificateHashes(model.certificateHashes);
        }

        public final Instant getSignatureTimestamp() {
            return this.signatureTimestamp;
        }

        public final void setSignatureTimestamp(Instant signatureTimestamp) {
            this.signatureTimestamp = signatureTimestamp;
        }

        @Override
        public final Builder signatureTimestamp(Instant signatureTimestamp) {
            this.signatureTimestamp = signatureTimestamp;
            return this;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getProfileVersionArn() {
            return this.profileVersionArn;
        }

        public final void setProfileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
        }

        @Override
        public final Builder profileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final Collection<String> getCertificateHashes() {
            if (this.certificateHashes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateHashes;
        }

        public final void setCertificateHashes(Collection<String> certificateHashes) {
            this.certificateHashes = CertificateHashesCopier.copy(certificateHashes);
        }

        @Override
        public final Builder certificateHashes(Collection<String> certificateHashes) {
            this.certificateHashes = CertificateHashesCopier.copy(certificateHashes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateHashes(String ... certificateHashes) {
            this.certificateHashes(Arrays.asList(certificateHashes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRevocationStatusRequest build() {
            return new GetRevocationStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRevocationStatusRequest> {
        public Builder signatureTimestamp(Instant var1);

        public Builder platformId(String var1);

        public Builder profileVersionArn(String var1);

        public Builder jobArn(String var1);

        public Builder certificateHashes(Collection<String> var1);

        public Builder certificateHashes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

