/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.EmergencyContact;
import software.amazon.awssdk.services.shield.model.EmergencyContactListCopier;
import software.amazon.awssdk.services.shield.model.ShieldRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEmergencyContactSettingsRequest
extends ShieldRequest
implements ToCopyableBuilder<Builder, UpdateEmergencyContactSettingsRequest> {
    private static final SdkField<List<EmergencyContact>> EMERGENCY_CONTACT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmergencyContactList").getter(UpdateEmergencyContactSettingsRequest.getter(UpdateEmergencyContactSettingsRequest::emergencyContactList)).setter(UpdateEmergencyContactSettingsRequest.setter(Builder::emergencyContactList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmergencyContactList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmergencyContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMERGENCY_CONTACT_LIST_FIELD));
    private final List<EmergencyContact> emergencyContactList;

    private UpdateEmergencyContactSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.emergencyContactList = builder.emergencyContactList;
    }

    public final boolean hasEmergencyContactList() {
        return this.emergencyContactList != null && !(this.emergencyContactList instanceof SdkAutoConstructList);
    }

    public final List<EmergencyContact> emergencyContactList() {
        return this.emergencyContactList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmergencyContactList() ? this.emergencyContactList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmergencyContactSettingsRequest)) {
            return false;
        }
        UpdateEmergencyContactSettingsRequest other = (UpdateEmergencyContactSettingsRequest)((Object)obj);
        return this.hasEmergencyContactList() == other.hasEmergencyContactList() && Objects.equals(this.emergencyContactList(), other.emergencyContactList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEmergencyContactSettingsRequest").add("EmergencyContactList", this.hasEmergencyContactList() ? this.emergencyContactList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmergencyContactList": {
                return Optional.ofNullable(clazz.cast(this.emergencyContactList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEmergencyContactSettingsRequest, T> g) {
        return obj -> g.apply((UpdateEmergencyContactSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldRequest.BuilderImpl
    implements Builder {
        private List<EmergencyContact> emergencyContactList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmergencyContactSettingsRequest model) {
            super(model);
            this.emergencyContactList(model.emergencyContactList);
        }

        public final List<EmergencyContact.Builder> getEmergencyContactList() {
            List<EmergencyContact.Builder> result = EmergencyContactListCopier.copyToBuilder(this.emergencyContactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmergencyContactList(Collection<EmergencyContact.BuilderImpl> emergencyContactList) {
            this.emergencyContactList = EmergencyContactListCopier.copyFromBuilder(emergencyContactList);
        }

        @Override
        public final Builder emergencyContactList(Collection<EmergencyContact> emergencyContactList) {
            this.emergencyContactList = EmergencyContactListCopier.copy(emergencyContactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emergencyContactList(EmergencyContact ... emergencyContactList) {
            this.emergencyContactList(Arrays.asList(emergencyContactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emergencyContactList(Consumer<EmergencyContact.Builder> ... emergencyContactList) {
            this.emergencyContactList(Stream.of(emergencyContactList).map(c -> (EmergencyContact)((EmergencyContact.Builder)EmergencyContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEmergencyContactSettingsRequest build() {
            return new UpdateEmergencyContactSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ShieldRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEmergencyContactSettingsRequest> {
        public Builder emergencyContactList(Collection<EmergencyContact> var1);

        public Builder emergencyContactList(EmergencyContact ... var1);

        public Builder emergencyContactList(Consumer<EmergencyContact.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

