/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportJobSummary.Builder, ImportJobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(ImportJobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<ImportDestination> IMPORT_DESTINATION_FIELD = SdkField
            .<ImportDestination> builder(MarshallingType.SDK_POJO).memberName("ImportDestination")
            .getter(getter(ImportJobSummary::importDestination)).setter(setter(Builder::importDestination))
            .constructor(ImportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestination").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ImportJobSummary::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ImportJobSummary::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProcessedRecordsCount").getter(getter(ImportJobSummary::processedRecordsCount))
            .setter(setter(Builder::processedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedRecordsCount").build())
            .build();

    private static final SdkField<Integer> FAILED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedRecordsCount").getter(getter(ImportJobSummary::failedRecordsCount))
            .setter(setter(Builder::failedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            IMPORT_DESTINATION_FIELD, JOB_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, PROCESSED_RECORDS_COUNT_FIELD,
            FAILED_RECORDS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final ImportDestination importDestination;

    private final String jobStatus;

    private final Instant createdTimestamp;

    private final Integer processedRecordsCount;

    private final Integer failedRecordsCount;

    private ImportJobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.importDestination = builder.importDestination;
        this.jobStatus = builder.jobStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.processedRecordsCount = builder.processedRecordsCount;
        this.failedRecordsCount = builder.failedRecordsCount;
    }

    /**
     * Returns the value of the JobId property for this object.
     * 
     * @return The value of the JobId property for this object.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * Returns the value of the ImportDestination property for this object.
     * 
     * @return The value of the ImportDestination property for this object.
     */
    public final ImportDestination importDestination() {
        return importDestination;
    }

    /**
     * Returns the value of the JobStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The value of the JobStatus property for this object.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * Returns the value of the JobStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The value of the JobStatus property for this object.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The date and time when the import job was created.
     * </p>
     * 
     * @return The date and time when the import job was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The current number of records processed.
     * </p>
     * 
     * @return The current number of records processed.
     */
    public final Integer processedRecordsCount() {
        return processedRecordsCount;
    }

    /**
     * <p>
     * The number of records that failed processing because of invalid input or other reasons.
     * </p>
     * 
     * @return The number of records that failed processing because of invalid input or other reasons.
     */
    public final Integer failedRecordsCount() {
        return failedRecordsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(importDestination());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobSummary)) {
            return false;
        }
        ImportJobSummary other = (ImportJobSummary) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(importDestination(), other.importDestination())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(processedRecordsCount(), other.processedRecordsCount())
                && Objects.equals(failedRecordsCount(), other.failedRecordsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportJobSummary").add("JobId", jobId()).add("ImportDestination", importDestination())
                .add("JobStatus", jobStatusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("ProcessedRecordsCount", processedRecordsCount()).add("FailedRecordsCount", failedRecordsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ImportDestination":
            return Optional.ofNullable(clazz.cast(importDestination()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "ProcessedRecordsCount":
            return Optional.ofNullable(clazz.cast(processedRecordsCount()));
        case "FailedRecordsCount":
            return Optional.ofNullable(clazz.cast(failedRecordsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportJobSummary, T> g) {
        return obj -> g.apply((ImportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportJobSummary> {
        /**
         * Sets the value of the JobId property for this object.
         *
         * @param jobId
         *        The new value for the JobId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * Sets the value of the ImportDestination property for this object.
         *
         * @param importDestination
         *        The new value for the ImportDestination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDestination(ImportDestination importDestination);

        /**
         * Sets the value of the ImportDestination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImportDestination.Builder} avoiding the
         * need to create one manually via {@link ImportDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #importDestination(ImportDestination)}.
         * 
         * @param importDestination
         *        a consumer that will call methods on {@link ImportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDestination(ImportDestination)
         */
        default Builder importDestination(Consumer<ImportDestination.Builder> importDestination) {
            return importDestination(ImportDestination.builder().applyMutation(importDestination).build());
        }

        /**
         * Sets the value of the JobStatus property for this object.
         *
         * @param jobStatus
         *        The new value for the JobStatus property for this object.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * Sets the value of the JobStatus property for this object.
         *
         * @param jobStatus
         *        The new value for the JobStatus property for this object.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The date and time when the import job was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The date and time when the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The current number of records processed.
         * </p>
         * 
         * @param processedRecordsCount
         *        The current number of records processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedRecordsCount(Integer processedRecordsCount);

        /**
         * <p>
         * The number of records that failed processing because of invalid input or other reasons.
         * </p>
         * 
         * @param failedRecordsCount
         *        The number of records that failed processing because of invalid input or other reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordsCount(Integer failedRecordsCount);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private ImportDestination importDestination;

        private String jobStatus;

        private Instant createdTimestamp;

        private Integer processedRecordsCount;

        private Integer failedRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobSummary model) {
            jobId(model.jobId);
            importDestination(model.importDestination);
            jobStatus(model.jobStatus);
            createdTimestamp(model.createdTimestamp);
            processedRecordsCount(model.processedRecordsCount);
            failedRecordsCount(model.failedRecordsCount);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final ImportDestination.Builder getImportDestination() {
            return importDestination != null ? importDestination.toBuilder() : null;
        }

        public final void setImportDestination(ImportDestination.BuilderImpl importDestination) {
            this.importDestination = importDestination != null ? importDestination.build() : null;
        }

        @Override
        public final Builder importDestination(ImportDestination importDestination) {
            this.importDestination = importDestination;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Integer getProcessedRecordsCount() {
            return processedRecordsCount;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final Integer getFailedRecordsCount() {
            return failedRecordsCount;
        }

        public final void setFailedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
        }

        @Override
        public final Builder failedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
            return this;
        }

        @Override
        public ImportJobSummary build() {
            return new ImportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
