/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ExportJobSummaryListCopier {
    static List<ExportJobSummary> copy(Collection<? extends ExportJobSummary> exportJobSummaryListParam) {
        List<ExportJobSummary> list;
        if (exportJobSummaryListParam == null || exportJobSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExportJobSummary> modifiableList = new ArrayList<>();
            exportJobSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExportJobSummary> copyFromBuilder(Collection<? extends ExportJobSummary.Builder> exportJobSummaryListParam) {
        List<ExportJobSummary> list;
        if (exportJobSummaryListParam == null || exportJobSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExportJobSummary> modifiableList = new ArrayList<>();
            exportJobSummaryListParam.forEach(entry -> {
                ExportJobSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExportJobSummary.Builder> copyToBuilder(Collection<? extends ExportJobSummary> exportJobSummaryListParam) {
        List<ExportJobSummary.Builder> list;
        if (exportJobSummaryListParam == null || exportJobSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExportJobSummary.Builder> modifiableList = new ArrayList<>();
            exportJobSummaryListParam.forEach(entry -> {
                ExportJobSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
