/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains configuration for Bring Your Own DKIM (BYODKIM), or, for Easy DKIM
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DkimSigningAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DkimSigningAttributes.Builder, DkimSigningAttributes> {
    private static final SdkField<String> DOMAIN_SIGNING_SELECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainSigningSelector").getter(getter(DkimSigningAttributes::domainSigningSelector))
            .setter(setter(Builder::domainSigningSelector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSigningSelector").build())
            .build();

    private static final SdkField<String> DOMAIN_SIGNING_PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainSigningPrivateKey").getter(getter(DkimSigningAttributes::domainSigningPrivateKey))
            .setter(setter(Builder::domainSigningPrivateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSigningPrivateKey").build())
            .build();

    private static final SdkField<String> NEXT_SIGNING_KEY_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextSigningKeyLength").getter(getter(DkimSigningAttributes::nextSigningKeyLengthAsString))
            .setter(setter(Builder::nextSigningKeyLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSigningKeyLength").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_SIGNING_SELECTOR_FIELD,
            DOMAIN_SIGNING_PRIVATE_KEY_FIELD, NEXT_SIGNING_KEY_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainSigningSelector;

    private final String domainSigningPrivateKey;

    private final String nextSigningKeyLength;

    private DkimSigningAttributes(BuilderImpl builder) {
        this.domainSigningSelector = builder.domainSigningSelector;
        this.domainSigningPrivateKey = builder.domainSigningPrivateKey;
        this.nextSigningKeyLength = builder.nextSigningKeyLength;
    }

    /**
     * <p>
     * [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
     * </p>
     * 
     * @return [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a
     *         domain.
     */
    public final String domainSigningSelector() {
        return domainSigningSelector;
    }

    /**
     * <p>
     * [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.
     * </p>
     * <p>
     * The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     * </p>
     * 
     * @return [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.</p>
     *         <p>
     *         The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     */
    public final String domainSigningPrivateKey() {
        return domainSigningPrivateKey;
    }

    /**
     * <p>
     * [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nextSigningKeyLength} will return {@link DkimSigningKeyLength#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nextSigningKeyLengthAsString}.
     * </p>
     * 
     * @return [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once
     *         per day.
     * @see DkimSigningKeyLength
     */
    public final DkimSigningKeyLength nextSigningKeyLength() {
        return DkimSigningKeyLength.fromValue(nextSigningKeyLength);
    }

    /**
     * <p>
     * [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nextSigningKeyLength} will return {@link DkimSigningKeyLength#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nextSigningKeyLengthAsString}.
     * </p>
     * 
     * @return [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once
     *         per day.
     * @see DkimSigningKeyLength
     */
    public final String nextSigningKeyLengthAsString() {
        return nextSigningKeyLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainSigningSelector());
        hashCode = 31 * hashCode + Objects.hashCode(domainSigningPrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(nextSigningKeyLengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimSigningAttributes)) {
            return false;
        }
        DkimSigningAttributes other = (DkimSigningAttributes) obj;
        return Objects.equals(domainSigningSelector(), other.domainSigningSelector())
                && Objects.equals(domainSigningPrivateKey(), other.domainSigningPrivateKey())
                && Objects.equals(nextSigningKeyLengthAsString(), other.nextSigningKeyLengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DkimSigningAttributes").add("DomainSigningSelector", domainSigningSelector())
                .add("DomainSigningPrivateKey", domainSigningPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NextSigningKeyLength", nextSigningKeyLengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainSigningSelector":
            return Optional.ofNullable(clazz.cast(domainSigningSelector()));
        case "DomainSigningPrivateKey":
            return Optional.ofNullable(clazz.cast(domainSigningPrivateKey()));
        case "NextSigningKeyLength":
            return Optional.ofNullable(clazz.cast(nextSigningKeyLengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DkimSigningAttributes, T> g) {
        return obj -> g.apply((DkimSigningAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DkimSigningAttributes> {
        /**
         * <p>
         * [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
         * </p>
         * 
         * @param domainSigningSelector
         *        [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainSigningSelector(String domainSigningSelector);

        /**
         * <p>
         * [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.
         * </p>
         * <p>
         * The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
         * </p>
         * 
         * @param domainSigningPrivateKey
         *        [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.</p>
         *        <p>
         *        The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainSigningPrivateKey(String domainSigningPrivateKey);

        /**
         * <p>
         * [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per
         * day.
         * </p>
         * 
         * @param nextSigningKeyLength
         *        [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most
         *        once per day.
         * @see DkimSigningKeyLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DkimSigningKeyLength
         */
        Builder nextSigningKeyLength(String nextSigningKeyLength);

        /**
         * <p>
         * [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per
         * day.
         * </p>
         * 
         * @param nextSigningKeyLength
         *        [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most
         *        once per day.
         * @see DkimSigningKeyLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DkimSigningKeyLength
         */
        Builder nextSigningKeyLength(DkimSigningKeyLength nextSigningKeyLength);
    }

    static final class BuilderImpl implements Builder {
        private String domainSigningSelector;

        private String domainSigningPrivateKey;

        private String nextSigningKeyLength;

        private BuilderImpl() {
        }

        private BuilderImpl(DkimSigningAttributes model) {
            domainSigningSelector(model.domainSigningSelector);
            domainSigningPrivateKey(model.domainSigningPrivateKey);
            nextSigningKeyLength(model.nextSigningKeyLength);
        }

        public final String getDomainSigningSelector() {
            return domainSigningSelector;
        }

        public final void setDomainSigningSelector(String domainSigningSelector) {
            this.domainSigningSelector = domainSigningSelector;
        }

        @Override
        public final Builder domainSigningSelector(String domainSigningSelector) {
            this.domainSigningSelector = domainSigningSelector;
            return this;
        }

        public final String getDomainSigningPrivateKey() {
            return domainSigningPrivateKey;
        }

        public final void setDomainSigningPrivateKey(String domainSigningPrivateKey) {
            this.domainSigningPrivateKey = domainSigningPrivateKey;
        }

        @Override
        public final Builder domainSigningPrivateKey(String domainSigningPrivateKey) {
            this.domainSigningPrivateKey = domainSigningPrivateKey;
            return this;
        }

        public final String getNextSigningKeyLength() {
            return nextSigningKeyLength;
        }

        public final void setNextSigningKeyLength(String nextSigningKeyLength) {
            this.nextSigningKeyLength = nextSigningKeyLength;
        }

        @Override
        public final Builder nextSigningKeyLength(String nextSigningKeyLength) {
            this.nextSigningKeyLength = nextSigningKeyLength;
            return this;
        }

        @Override
        public final Builder nextSigningKeyLength(DkimSigningKeyLength nextSigningKeyLength) {
            this.nextSigningKeyLength(nextSigningKeyLength == null ? null : nextSigningKeyLength.toString());
            return this;
        }

        @Override
        public DkimSigningAttributes build() {
            return new DkimSigningAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
