/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;

public class ListConfigurationSetsPublisher
implements SdkPublisher<ListConfigurationSetsResponse> {
    private final SesV2AsyncClient client;
    private final ListConfigurationSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationSetsPublisher(SesV2AsyncClient client, ListConfigurationSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationSetsPublisher(SesV2AsyncClient client, ListConfigurationSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListConfigurationSetsResponseFetcher
    implements AsyncPageFetcher<ListConfigurationSetsResponse> {
        private ListConfigurationSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationSetsResponse> nextPage(ListConfigurationSetsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationSetsPublisher.this.client.listConfigurationSets(ListConfigurationSetsPublisher.this.firstRequest);
            }
            return ListConfigurationSetsPublisher.this.client.listConfigurationSets((ListConfigurationSetsRequest)((Object)ListConfigurationSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

