/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.InsightsEvent;
import software.amazon.awssdk.services.sesv2.model.InsightsEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailInsights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailInsights> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(EmailInsights.getter(EmailInsights::destination)).setter(EmailInsights.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> ISP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Isp").getter(EmailInsights.getter(EmailInsights::isp)).setter(EmailInsights.setter(Builder::isp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Isp").build()}).build();
    private static final SdkField<List<InsightsEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(EmailInsights.getter(EmailInsights::events)).setter(EmailInsights.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightsEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, ISP_FIELD, EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destination;
    private final String isp;
    private final List<InsightsEvent> events;

    private EmailInsights(BuilderImpl builder) {
        this.destination = builder.destination;
        this.isp = builder.isp;
        this.events = builder.events;
    }

    public final String destination() {
        return this.destination;
    }

    public final String isp() {
        return this.isp;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<InsightsEvent> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.isp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailInsights)) {
            return false;
        }
        EmailInsights other = (EmailInsights)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.isp(), other.isp()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"EmailInsights").add("Destination", (Object)(this.destination() == null ? null : "*** Sensitive Data Redacted ***")).add("Isp", (Object)this.isp()).add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Isp": {
                return Optional.ofNullable(clazz.cast(this.isp()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailInsights, T> g) {
        return obj -> g.apply((EmailInsights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destination;
        private String isp;
        private List<InsightsEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailInsights model) {
            this.destination(model.destination);
            this.isp(model.isp);
            this.events(model.events);
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getIsp() {
            return this.isp;
        }

        public final void setIsp(String isp) {
            this.isp = isp;
        }

        @Override
        public final Builder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public final List<InsightsEvent.Builder> getEvents() {
            List<InsightsEvent.Builder> result = InsightsEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<InsightsEvent.BuilderImpl> events) {
            this.events = InsightsEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<InsightsEvent> events) {
            this.events = InsightsEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InsightsEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<InsightsEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (InsightsEvent)((InsightsEvent.Builder)InsightsEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EmailInsights build() {
            return new EmailInsights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailInsights> {
        public Builder destination(String var1);

        public Builder isp(String var1);

        public Builder events(Collection<InsightsEvent> var1);

        public Builder events(InsightsEvent ... var1);

        public Builder events(Consumer<InsightsEvent.Builder> ... var1);
    }
}

