/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse;

public class ListCustomVerificationEmailTemplatesIterable
implements SdkIterable<ListCustomVerificationEmailTemplatesResponse> {
    private final SesV2Client client;
    private final ListCustomVerificationEmailTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomVerificationEmailTemplatesIterable(SesV2Client client, ListCustomVerificationEmailTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomVerificationEmailTemplatesResponseFetcher();
    }

    public Iterator<ListCustomVerificationEmailTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCustomVerificationEmailTemplatesResponseFetcher
    implements SyncPageFetcher<ListCustomVerificationEmailTemplatesResponse> {
        private ListCustomVerificationEmailTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomVerificationEmailTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomVerificationEmailTemplatesResponse nextPage(ListCustomVerificationEmailTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCustomVerificationEmailTemplatesIterable.this.client.listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesIterable.this.firstRequest);
            }
            return ListCustomVerificationEmailTemplatesIterable.this.client.listCustomVerificationEmailTemplates((ListCustomVerificationEmailTemplatesRequest)((Object)ListCustomVerificationEmailTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

