/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;

public class ListNamespacesPublisher
implements SdkPublisher<ListNamespacesResponse> {
    private final ServiceDiscoveryAsyncClient client;
    private final ListNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNamespacesPublisher(ServiceDiscoveryAsyncClient client, ListNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNamespacesPublisher(ServiceDiscoveryAsyncClient client, ListNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListNamespacesResponseFetcher
    implements AsyncPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNamespacesResponse> nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesPublisher.this.client.listNamespaces(ListNamespacesPublisher.this.firstRequest);
            }
            return ListNamespacesPublisher.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

