/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterCondition {
    EQ("EQ"),
    IN("IN"),
    BETWEEN("BETWEEN"),
    BEGINS_WITH("BEGINS_WITH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterCondition> VALUE_MAP;
    private final String value;

    private FilterCondition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterCondition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterCondition> knownValues() {
        EnumSet<FilterCondition> knownValues = EnumSet.allOf(FilterCondition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterCondition.class, FilterCondition::toString);
    }
}

