/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryAsyncClient;
import software.amazon.awssdk.services.servicecatalogappregistry.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupDetails;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse;

public class ListAttributeGroupsForApplicationPublisher
implements SdkPublisher<ListAttributeGroupsForApplicationResponse> {
    private final ServiceCatalogAppRegistryAsyncClient client;
    private final ListAttributeGroupsForApplicationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttributeGroupsForApplicationPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAttributeGroupsForApplicationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttributeGroupsForApplicationPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAttributeGroupsForApplicationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttributeGroupsForApplicationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttributeGroupsForApplicationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttributeGroupDetails> attributeGroupsDetails() {
        Function<ListAttributeGroupsForApplicationResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeGroupsDetails() != null) {
                return response.attributeGroupsDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttributeGroupsForApplicationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttributeGroupsForApplicationResponseFetcher
    implements AsyncPageFetcher<ListAttributeGroupsForApplicationResponse> {
        private ListAttributeGroupsForApplicationResponseFetcher() {
        }

        public boolean hasNextPage(ListAttributeGroupsForApplicationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttributeGroupsForApplicationResponse> nextPage(ListAttributeGroupsForApplicationResponse previousPage) {
            if (previousPage == null) {
                return ListAttributeGroupsForApplicationPublisher.this.client.listAttributeGroupsForApplication(ListAttributeGroupsForApplicationPublisher.this.firstRequest);
            }
            return ListAttributeGroupsForApplicationPublisher.this.client.listAttributeGroupsForApplication((ListAttributeGroupsForApplicationRequest)((Object)ListAttributeGroupsForApplicationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

