/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.LastSync;
import software.amazon.awssdk.services.servicecatalog.model.SourceConnectionParameters;
import software.amazon.awssdk.services.servicecatalog.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceConnectionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceConnectionDetail> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SourceConnectionDetail.getter(SourceConnectionDetail::typeAsString)).setter(SourceConnectionDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<SourceConnectionParameters> CONNECTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionParameters").getter(SourceConnectionDetail.getter(SourceConnectionDetail::connectionParameters)).setter(SourceConnectionDetail.setter(Builder::connectionParameters)).constructor(SourceConnectionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionParameters").build()}).build();
    private static final SdkField<LastSync> LAST_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastSync").getter(SourceConnectionDetail.getter(SourceConnectionDetail::lastSync)).setter(SourceConnectionDetail.setter(Builder::lastSync)).constructor(LastSync::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSync").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONNECTION_PARAMETERS_FIELD, LAST_SYNC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final SourceConnectionParameters connectionParameters;
    private final LastSync lastSync;

    private SourceConnectionDetail(BuilderImpl builder) {
        this.type = builder.type;
        this.connectionParameters = builder.connectionParameters;
        this.lastSync = builder.lastSync;
    }

    public final SourceType type() {
        return SourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final SourceConnectionParameters connectionParameters() {
        return this.connectionParameters;
    }

    public final LastSync lastSync() {
        return this.lastSync;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSync());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectionDetail)) {
            return false;
        }
        SourceConnectionDetail other = (SourceConnectionDetail)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.connectionParameters(), other.connectionParameters()) && Objects.equals(this.lastSync(), other.lastSync());
    }

    public final String toString() {
        return ToString.builder((String)"SourceConnectionDetail").add("Type", (Object)this.typeAsString()).add("ConnectionParameters", (Object)this.connectionParameters()).add("LastSync", (Object)this.lastSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ConnectionParameters": {
                return Optional.ofNullable(clazz.cast(this.connectionParameters()));
            }
            case "LastSync": {
                return Optional.ofNullable(clazz.cast(this.lastSync()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectionDetail, T> g) {
        return obj -> g.apply((SourceConnectionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private SourceConnectionParameters connectionParameters;
        private LastSync lastSync;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectionDetail model) {
            this.type(model.type);
            this.connectionParameters(model.connectionParameters);
            this.lastSync(model.lastSync);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final SourceConnectionParameters.Builder getConnectionParameters() {
            return this.connectionParameters != null ? this.connectionParameters.toBuilder() : null;
        }

        public final void setConnectionParameters(SourceConnectionParameters.BuilderImpl connectionParameters) {
            this.connectionParameters = connectionParameters != null ? connectionParameters.build() : null;
        }

        @Override
        public final Builder connectionParameters(SourceConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
            return this;
        }

        public final LastSync.Builder getLastSync() {
            return this.lastSync != null ? this.lastSync.toBuilder() : null;
        }

        public final void setLastSync(LastSync.BuilderImpl lastSync) {
            this.lastSync = lastSync != null ? lastSync.build() : null;
        }

        @Override
        public final Builder lastSync(LastSync lastSync) {
            this.lastSync = lastSync;
            return this;
        }

        public SourceConnectionDetail build() {
            return new SourceConnectionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceConnectionDetail> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder connectionParameters(SourceConnectionParameters var1);

        default public Builder connectionParameters(Consumer<SourceConnectionParameters.Builder> connectionParameters) {
            return this.connectionParameters((SourceConnectionParameters)((SourceConnectionParameters.Builder)SourceConnectionParameters.builder().applyMutation(connectionParameters)).build());
        }

        public Builder lastSync(LastSync var1);

        default public Builder lastSync(Consumer<LastSync.Builder> lastSync) {
            return this.lastSync((LastSync)((LastSync.Builder)LastSync.builder().applyMutation(lastSync)).build());
        }
    }
}

