/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConstraintRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdateConstraintRequest.Builder, UpdateConstraintRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(UpdateConstraintRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateConstraintRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConstraintRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(UpdateConstraintRequest::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            ID_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD));

    private final String acceptLanguage;

    private final String id;

    private final String description;

    private final String parameters;

    private UpdateConstraintRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The identifier of the constraint.
     * </p>
     * 
     * @return The identifier of the constraint.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The updated description of the constraint.
     * </p>
     * 
     * @return The updated description of the constraint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
     * </p>
     * <dl>
     * <dt>LAUNCH</dt>
     * <dd>
     * <p>
     * You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.
     * </p>
     * <p>
     * Specify the <code>RoleArn</code> property as follows:
     * </p>
     * <p>
     * <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
     * </p>
     * <p>
     * Specify the <code>LocalRoleName</code> property as follows:
     * </p>
     * <p>
     * <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
     * </p>
     * <p>
     * If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role
     * with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the
     * administrator can create fewer resources per shared account.
     * </p>
     * <note>
     * <p>
     * The given role name must exist in the account used to create the launch constraint and the account of the user
     * who launches a product with this launch constraint.
     * </p>
     * </note>
     * <p>
     * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     * </p>
     * <p>
     * You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
     * </p>
     * </dd>
     * <dt>NOTIFICATION</dt>
     * <dd>
     * <p>
     * Specify the <code>NotificationArns</code> property as follows:
     * </p>
     * <p>
     * <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
     * </p>
     * </dd>
     * <dt>RESOURCE_UPDATE</dt>
     * <dd>
     * <p>
     * Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
     * </p>
     * <p>
     * <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
     * </p>
     * <p>
     * The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or
     * <code>NOT_ALLOWED</code>.
     * </p>
     * </dd>
     * <dt>STACKSET</dt>
     * <dd>
     * <p>
     * Specify the <code>Parameters</code> property as follows:
     * </p>
     * <p>
     * <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
     * </p>
     * <p>
     * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     * </p>
     * <p>
     * You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
     * </p>
     * <p>
     * Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
     * </p>
     * </dd>
     * <dt>TEMPLATE</dt>
     * <dd>
     * <p>
     * Specify the <code>Rules</code> property. For more information, see <a
     * href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
     * >Template Constraint Rules</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
     *         <dl>
     *         <dt>LAUNCH</dt>
     *         <dd>
     *         <p>
     *         You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't
     *         use both.
     *         </p>
     *         <p>
     *         Specify the <code>RoleArn</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
     *         </p>
     *         <p>
     *         Specify the <code>LocalRoleName</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
     *         </p>
     *         <p>
     *         If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the
     *         IAM role with that name in the account will be used. This allows launch-role constraints to be
     *         account-agnostic so the administrator can create fewer resources per shared account.
     *         </p>
     *         <note>
     *         <p>
     *         The given role name must exist in the account used to create the launch constraint and the account of the
     *         user who launches a product with this launch constraint.
     *         </p>
     *         </note>
     *         <p>
     *         You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     *         </p>
     *         <p>
     *         You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
     *         </p>
     *         </dd>
     *         <dt>NOTIFICATION</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>NotificationArns</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
     *         </p>
     *         </dd>
     *         <dt>RESOURCE_UPDATE</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
     *         </p>
     *         <p>
     *         The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code>
     *         or <code>NOT_ALLOWED</code>.
     *         </p>
     *         </dd>
     *         <dt>STACKSET</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>Parameters</code> property as follows:
     *         </p>
     *         <p>
     *         <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
     *         </p>
     *         <p>
     *         You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
     *         </p>
     *         <p>
     *         You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
     *         </p>
     *         <p>
     *         Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
     *         </p>
     *         </dd>
     *         <dt>TEMPLATE</dt>
     *         <dd>
     *         <p>
     *         Specify the <code>Rules</code> property. For more information, see <a
     *         href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
     *         >Template Constraint Rules</a>.
     *         </p>
     *         </dd>
     */
    public final String parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConstraintRequest)) {
            return false;
        }
        UpdateConstraintRequest other = (UpdateConstraintRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConstraintRequest").add("AcceptLanguage", acceptLanguage()).add("Id", id())
                .add("Description", description()).add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConstraintRequest, T> g) {
        return obj -> g.apply((UpdateConstraintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConstraintRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The identifier of the constraint.
         * </p>
         * 
         * @param id
         *        The identifier of the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The updated description of the constraint.
         * </p>
         * 
         * @param description
         *        The updated description of the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
         * </p>
         * <dl>
         * <dt>LAUNCH</dt>
         * <dd>
         * <p>
         * You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use
         * both.
         * </p>
         * <p>
         * Specify the <code>RoleArn</code> property as follows:
         * </p>
         * <p>
         * <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
         * </p>
         * <p>
         * Specify the <code>LocalRoleName</code> property as follows:
         * </p>
         * <p>
         * <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
         * </p>
         * <p>
         * If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM
         * role with that name in the account will be used. This allows launch-role constraints to be account-agnostic
         * so the administrator can create fewer resources per shared account.
         * </p>
         * <note>
         * <p>
         * The given role name must exist in the account used to create the launch constraint and the account of the
         * user who launches a product with this launch constraint.
         * </p>
         * </note>
         * <p>
         * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         * </p>
         * <p>
         * You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
         * </p>
         * </dd>
         * <dt>NOTIFICATION</dt>
         * <dd>
         * <p>
         * Specify the <code>NotificationArns</code> property as follows:
         * </p>
         * <p>
         * <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
         * </p>
         * </dd>
         * <dt>RESOURCE_UPDATE</dt>
         * <dd>
         * <p>
         * Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
         * </p>
         * <p>
         * <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
         * </p>
         * <p>
         * The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or
         * <code>NOT_ALLOWED</code>.
         * </p>
         * </dd>
         * <dt>STACKSET</dt>
         * <dd>
         * <p>
         * Specify the <code>Parameters</code> property as follows:
         * </p>
         * <p>
         * <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
         * </p>
         * <p>
         * You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         * </p>
         * <p>
         * You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
         * </p>
         * <p>
         * Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
         * </p>
         * </dd>
         * <dt>TEMPLATE</dt>
         * <dd>
         * <p>
         * Specify the <code>Rules</code> property. For more information, see <a
         * href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
         * >Template Constraint Rules</a>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param parameters
         *        The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
         *        <dl>
         *        <dt>LAUNCH</dt>
         *        <dd>
         *        <p>
         *        You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but
         *        can't use both.
         *        </p>
         *        <p>
         *        Specify the <code>RoleArn</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
         *        </p>
         *        <p>
         *        Specify the <code>LocalRoleName</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
         *        </p>
         *        <p>
         *        If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint,
         *        the IAM role with that name in the account will be used. This allows launch-role constraints to be
         *        account-agnostic so the administrator can create fewer resources per shared account.
         *        </p>
         *        <note>
         *        <p>
         *        The given role name must exist in the account used to create the launch constraint and the account of
         *        the user who launches a product with this launch constraint.
         *        </p>
         *        </note>
         *        <p>
         *        You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         *        </p>
         *        <p>
         *        You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.
         *        </p>
         *        </dd>
         *        <dt>NOTIFICATION</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>NotificationArns</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
         *        </p>
         *        </dd>
         *        <dt>RESOURCE_UPDATE</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
         *        </p>
         *        <p>
         *        The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of
         *        <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.
         *        </p>
         *        </dd>
         *        <dt>STACKSET</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>Parameters</code> property as follows:
         *        </p>
         *        <p>
         *        <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
         *        </p>
         *        <p>
         *        You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.
         *        </p>
         *        <p>
         *        You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.
         *        </p>
         *        <p>
         *        Products with a <code>STACKSET</code> constraint will launch an CloudFormation stack set.
         *        </p>
         *        </dd>
         *        <dt>TEMPLATE</dt>
         *        <dd>
         *        <p>
         *        Specify the <code>Rules</code> property. For more information, see <a
         *        href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html"
         *        >Template Constraint Rules</a>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String id;

        private String description;

        private String parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConstraintRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            id(model.id);
            description(model.description);
            parameters(model.parameters);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConstraintRequest build() {
            return new UpdateConstraintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
