/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse;

public class ListResourcesForTagOptionIterable
implements SdkIterable<ListResourcesForTagOptionResponse> {
    private final ServiceCatalogClient client;
    private final ListResourcesForTagOptionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcesForTagOptionIterable(ServiceCatalogClient client, ListResourcesForTagOptionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourcesForTagOptionResponseFetcher();
    }

    public Iterator<ListResourcesForTagOptionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResourcesForTagOptionResponseFetcher
    implements SyncPageFetcher<ListResourcesForTagOptionResponse> {
        private ListResourcesForTagOptionResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesForTagOptionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.pageToken());
        }

        public ListResourcesForTagOptionResponse nextPage(ListResourcesForTagOptionResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesForTagOptionIterable.this.client.listResourcesForTagOption(ListResourcesForTagOptionIterable.this.firstRequest);
            }
            return ListResourcesForTagOptionIterable.this.client.listResourcesForTagOption((ListResourcesForTagOptionRequest)((Object)ListResourcesForTagOptionIterable.this.firstRequest.toBuilder().pageToken(previousPage.pageToken()).build()));
        }
    }
}

