/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;

public class ListPortfoliosForProductIterable
implements SdkIterable<ListPortfoliosForProductResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfoliosForProductRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortfoliosForProductIterable(ServiceCatalogClient client, ListPortfoliosForProductRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPortfoliosForProductResponseFetcher();
    }

    public Iterator<ListPortfoliosForProductResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPortfoliosForProductResponseFetcher
    implements SyncPageFetcher<ListPortfoliosForProductResponse> {
        private ListPortfoliosForProductResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosForProductResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListPortfoliosForProductResponse nextPage(ListPortfoliosForProductResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosForProductIterable.this.client.listPortfoliosForProduct(ListPortfoliosForProductIterable.this.firstRequest);
            }
            return ListPortfoliosForProductIterable.this.client.listPortfoliosForProduct((ListPortfoliosForProductRequest)((Object)ListPortfoliosForProductIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

